/****************************************************************************
** $Id:  cmds/cmdslice.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDSLICE_H
#define CMDSLICE_H
#include "cmds.h"


void cmds::cmdslice(){
	int i,j,k,w;
	int temp;
	double plan[4];
	double var[5];
	int check=0;
	float tempo[3];float tempon[3];float tempoc[3];float tempot[2];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			SendText(tr("--Slice--"));
			instruction=tr("pickpoint 1:");emit instru(instruction);
			emit SetMouseMode(MOUSEMODE_PICKPOINT);
			step++;
			return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				tempdataTRI[0].v1[0]=currentdata.v[0];tempdataTRI[0].v1[1]=currentdata.v[1];tempdataTRI[0].v1[2]=currentdata.v[2];
				tempdataTRI[0].c1[0]=currentcolor[0];tempdataTRI[0].c1[1]=currentcolor[1];tempdataTRI[0].c1[2]=currentcolor[2];
				/*/////////*/
				instruction=tr("pickpoint 2 or [Undo]:");emit instru(instruction);
				step++;
				return;
			}
			

		break;
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("U","Undo"))||!SecCmd.compare(tr("u","Undo"))){
					SendText(SecCmd);
					instruction=tr("pickpoint 1:");emit instru(instruction);
					rtlines[0].find=0;SecCmd="BlankCommand";step--;
			return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				
				rtcolor1[0]=rtcolor[0];rtcolor1[1]=rtcolor[1];rtcolor1[2]=rtcolor[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[1].v[0]=rtlines[0].v[0];rtlines[1].v[1]=rtlines[0].v[1];rtlines[1].v[2]=rtlines[0].v[2];
				
				if(currentdata.format==0){
					tempdataTRI[0].v2[0]=currentdata.v[0];tempdataTRI[0].v2[1]=currentdata.v[1];tempdataTRI[0].v2[2]=currentdata.v[2];
					rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					tempdataTRI[0].v2[0]=rtlines[0].v[0]+currentdata.v[0];
					tempdataTRI[0].v2[1]=rtlines[0].v[1]+currentdata.v[1];
					tempdataTRI[0].v2[2]=rtlines[0].v[2]+currentdata.v[2];
					
					rtlines[0].v[0]+=currentdata.v[0];
					rtlines[0].v[1]+=currentdata.v[1];
					rtlines[0].v[2]+=currentdata.v[2];
				}
				rtlines[1].find=1;
				tempdataTRI[0].c2[0]=currentcolor[0];tempdataTRI[0].c2[1]=currentcolor[1];tempdataTRI[0].c2[2]=currentcolor[2];
				
				instruction=tr("Next point:");emit instru(instruction);
				step++;
			return;
			}
		break;
		case 3:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("U"))||!SecCmd.compare(tr("u"))){
					SendText(SecCmd);
					rtlines[0].v[0]=rtlines[1].v[0];rtlines[0].v[1]=rtlines[1].v[1];rtlines[0].v[2]=rtlines[1].v[2];
					rtcolor[0]=rtcolor1[0];rtcolor[1]=rtcolor1[1];rtcolor[2]=rtcolor1[2];
					rtlines[1].find=0;
					step--;
					instruction=tr("pickpoint 2 or [Undo]:");emit instru(instruction);
					SecCmd="BlankCommand";
			return;
			}
			
			if(!SecCmd.compare("setCmdData")){
			
			
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					tempdataTRI[0].v3[0]=currentdata.v[0];tempdataTRI[0].v3[1]=currentdata.v[1];tempdataTRI[0].v3[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					tempdataTRI[0].v3[0]=rtlines[0].v[0]+currentdata.v[0];
					tempdataTRI[0].v3[1]=rtlines[0].v[1]+currentdata.v[1];
					tempdataTRI[0].v3[2]=rtlines[0].v[2]+currentdata.v[2];
				}
plan[0]=tempdataTRI[0].v1[1]*(tempdataTRI[0].v2[2]-tempdataTRI[0].v3[2])-tempdataTRI[0].v1[2]*(tempdataTRI[0].v2[1]-tempdataTRI[0].v3[1])+tempdataTRI[0].v2[1]*tempdataTRI[0].v3[2]-tempdataTRI[0].v2[2]*tempdataTRI[0].v3[1];

plan[1]=-(tempdataTRI[0].v1[0]*(tempdataTRI[0].v2[2]-tempdataTRI[0].v3[2])-tempdataTRI[0].v1[2]*(tempdataTRI[0].v2[0]-tempdataTRI[0].v3[0])+tempdataTRI[0].v2[0]*tempdataTRI[0].v3[2]-tempdataTRI[0].v2[2]*tempdataTRI[0].v3[0]);

plan[2]=tempdataTRI[0].v1[0]*(tempdataTRI[0].v2[1]-tempdataTRI[0].v3[1])-tempdataTRI[0].v1[1]*(tempdataTRI[0].v2[0]-tempdataTRI[0].v3[0])+tempdataTRI[0].v2[0]*tempdataTRI[0].v3[1]-tempdataTRI[0].v2[1]*tempdataTRI[0].v3[0];

plan[3]=-(tempdataTRI[0].v1[0]*(tempdataTRI[0].v2[1]*tempdataTRI[0].v3[2]-tempdataTRI[0].v2[2]*tempdataTRI[0].v3[1])-tempdataTRI[0].v1[1]*(tempdataTRI[0].v2[0]*tempdataTRI[0].v3[2]-tempdataTRI[0].v2[2]*tempdataTRI[0].v3[0])+tempdataTRI[0].v1[2]*(tempdataTRI[0].v2[0]*tempdataTRI[0].v3[1]-tempdataTRI[0].v2[1]*tempdataTRI[0].v3[0]));
				
var[0]=sqrt(plan[0]*plan[0]+plan[1]*plan[1]+plan[2]*plan[2]);
			if(var[0]==0.0){
				SendText(tr("Error"));
				CmdCancel();
				return;
			}
			/*if(plan[3]!=0.0){
				if(plan[3]>0.0){var[0]=-var[0];}
			}else{
				if(plan[2]!=0.0){
					if(plan[2]<0.0){var[0]=-var[0];}
				}else{
					if(plan[1]!=0.0){
						if(plan[1]<0.0){var[0]=-var[0];}
					}else{
						if(plan[0]<0.0){var[0]=-var[0];}}
				}
			}*/
			plan[0]/=var[0];plan[1]/=var[0];plan[2]/=var[0];plan[3]/=var[0];
			for(i=DataSV.size()-1,w=0;i>=w;i--){
			check=0;
				if(DataSV[i].type==1){
					k=DataSV[i].index;
					var[0]=DLV[k].v1[0]*plan[0]+DLV[k].v1[1]*plan[1]+DLV[k].v1[2]*plan[2]+plan[3];
					var[1]=DLV[k].v2[0]*plan[0]+DLV[k].v2[1]*plan[1]+DLV[k].v2[2]*plan[2]+plan[3];
					
					if(var[0]>=0.0&&var[1]>=0.0){
						temp=DataSV[w].type;DataSV[w].type=DataSV[i].type;DataSV[i].type=temp;
						temp=DataSV[w].index;DataSV[w].index=DataSV[i].index;DataSV[i].index=temp;
						w++;i++;
					}
					if(var[0]<0.0&&var[1]>0.0){
			var[3]=plan[0]*(DLV[k].v1[0]-DLV[k].v2[0])+plan[1]*(DLV[k].v1[1]-DLV[k].v2[1])+plan[2]*(DLV[k].v1[2]-DLV[k].v2[2]);
						DLV[k].v2[0]=DLV[k].v1[0]+var[0]*(DLV[k].v2[0]-DLV[k].v1[0])/var[3];
						DLV[k].v2[1]=DLV[k].v1[1]+var[0]*(DLV[k].v2[1]-DLV[k].v1[1])/var[3];
						DLV[k].v2[2]=DLV[k].v1[2]+var[0]*(DLV[k].v2[2]-DLV[k].v1[2])/var[3];
						
						
						DLV[k].c2[0]=DLV[k].c1[0]+var[0]*(DLV[k].c2[0]-DLV[k].c1[0])/var[3];
						DLV[k].c2[1]=DLV[k].c1[1]+var[0]*(DLV[k].c2[1]-DLV[k].c1[1])/var[3];
						DLV[k].c2[2]=DLV[k].c1[2]+var[0]*(DLV[k].c2[2]-DLV[k].c1[2])/var[3];
					
					}
					if(var[0]>0.0&&var[1]<0.0){
			var[3]=plan[0]*(DLV[k].v1[0]-DLV[k].v2[0])+plan[1]*(DLV[k].v1[1]-DLV[k].v2[1])+plan[2]*(DLV[k].v1[2]-DLV[k].v2[2]);
						DLV[k].v1[0]=DLV[k].v1[0]+var[0]*(DLV[k].v2[0]-DLV[k].v1[0])/var[3];
						DLV[k].v1[1]=DLV[k].v1[1]+var[0]*(DLV[k].v2[1]-DLV[k].v1[1])/var[3];
						DLV[k].v1[2]=DLV[k].v1[2]+var[0]*(DLV[k].v2[2]-DLV[k].v1[2])/var[3];
						
						
						DLV[k].c1[0]=DLV[k].c1[0]+var[0]*(DLV[k].c2[0]-DLV[k].c1[0])/var[3];
						DLV[k].c1[1]=DLV[k].c1[1]+var[0]*(DLV[k].c2[1]-DLV[k].c1[1])/var[3];
						DLV[k].c1[2]=DLV[k].c1[2]+var[0]*(DLV[k].c2[2]-DLV[k].c1[2])/var[3];
					
					}

			
				}else{
					if(DataSV[i].type==2){
						k=DataSV[i].index;
						var[0]=DTV[k].v1[0]*plan[0]+DTV[k].v1[1]*plan[1]+DTV[k].v1[2]*plan[2]+plan[3];
						var[1]=DTV[k].v2[0]*plan[0]+DTV[k].v2[1]*plan[1]+DTV[k].v2[2]*plan[2]+plan[3];
						var[2]=DTV[k].v3[0]*plan[0]+DTV[k].v3[1]*plan[1]+DTV[k].v3[2]*plan[2]+plan[3];
		/*SendText(QString("dist1 %1,dist2 %2, dist3 %3").arg(var[0]).arg(var[1]).arg(var[2]));*/
						if(var[0]>=0.0&&var[1]>=0.0&&var[2]>=0.0){
							temp=DataSV[w].type;DataSV[w].type=DataSV[i].type;DataSV[i].type=temp;
							temp=DataSV[w].index;DataSV[w].index=DataSV[i].index;DataSV[i].index=temp;
							w++;i++;
						}
					if((var[0]<0.0&&var[1]>=0.0&&var[2]>=0.0)&&!check){
					check=1;
			var[3]=plan[0]*(DTV[k].v1[0]-DTV[k].v2[0])+plan[1]*(DTV[k].v1[1]-DTV[k].v2[1])+plan[2]*(DTV[k].v1[2]-DTV[k].v2[2]);
						DTV[k].v2[0]=DTV[k].v1[0]+var[0]*(DTV[k].v2[0]-DTV[k].v1[0])/var[3];
						DTV[k].v2[1]=DTV[k].v1[1]+var[0]*(DTV[k].v2[1]-DTV[k].v1[1])/var[3];
						DTV[k].v2[2]=DTV[k].v1[2]+var[0]*(DTV[k].v2[2]-DTV[k].v1[2])/var[3];
			
						DTV[k].n2[0]=DTV[k].n1[0]+var[0]*(DTV[k].n2[0]-DTV[k].n1[0])/var[3];
						DTV[k].n2[1]=DTV[k].n1[1]+var[0]*(DTV[k].n2[1]-DTV[k].n1[1])/var[3];
						DTV[k].n2[2]=DTV[k].n1[2]+var[0]*(DTV[k].n2[2]-DTV[k].n1[2])/var[3];
						var[4]=sqrt(DTV[k].n2[0]*DTV[k].n2[0]+DTV[k].n2[1]*DTV[k].n2[1]+DTV[k].n2[2]*DTV[k].n2[2]);
						DTV[k].n2[0]/=var[4];DTV[k].n2[1]/=var[4];DTV[k].n2[2]/=var[4];
						
						DTV[k].c2[0]=DTV[k].c1[0]+var[0]*(DTV[k].c2[0]-DTV[k].c1[0])/var[3];
						DTV[k].c2[1]=DTV[k].c1[1]+var[0]*(DTV[k].c2[1]-DTV[k].c1[1])/var[3];
						DTV[k].c2[2]=DTV[k].c1[2]+var[0]*(DTV[k].c2[2]-DTV[k].c1[2])/var[3];
						
						DTV[k].t2[0]=DTV[k].t1[0]+var[0]*(DTV[k].t2[0]-DTV[k].t1[0])/var[3];
						DTV[k].t2[1]=DTV[k].t1[1]+var[0]*(DTV[k].t2[1]-DTV[k].t1[1])/var[3];
						
			
			var[3]=plan[0]*(DTV[k].v1[0]-DTV[k].v3[0])+plan[1]*(DTV[k].v1[1]-DTV[k].v3[1])+plan[2]*(DTV[k].v1[2]-DTV[k].v3[2]);
						DTV[k].v3[0]=DTV[k].v1[0]+var[0]*(DTV[k].v3[0]-DTV[k].v1[0])/var[3];
						DTV[k].v3[1]=DTV[k].v1[1]+var[0]*(DTV[k].v3[1]-DTV[k].v1[1])/var[3];
						DTV[k].v3[2]=DTV[k].v1[2]+var[0]*(DTV[k].v3[2]-DTV[k].v1[2])/var[3];
						
						DTV[k].n3[0]=DTV[k].n1[0]+var[0]*(DTV[k].n3[0]-DTV[k].n1[0])/var[3];
						DTV[k].n3[1]=DTV[k].n1[1]+var[0]*(DTV[k].n3[1]-DTV[k].n1[1])/var[3];
						DTV[k].n3[2]=DTV[k].n1[2]+var[0]*(DTV[k].n3[2]-DTV[k].n1[2])/var[3];
						var[4]=sqrt(DTV[k].n3[0]*DTV[k].n3[0]+DTV[k].n3[1]*DTV[k].n3[1]+DTV[k].n3[2]*DTV[k].n3[2]);
						DTV[k].n3[0]/=var[4];DTV[k].n3[1]/=var[4];DTV[k].n3[2]/=var[4];
						
						DTV[k].c3[0]=DTV[k].c1[0]+var[0]*(DTV[k].c3[0]-DTV[k].c1[0])/var[3];
						DTV[k].c3[1]=DTV[k].c1[1]+var[0]*(DTV[k].c3[1]-DTV[k].c1[1])/var[3];
						DTV[k].c3[2]=DTV[k].c1[2]+var[0]*(DTV[k].c3[2]-DTV[k].c1[2])/var[3];
						
						DTV[k].t3[0]=DTV[k].t1[0]+var[0]*(DTV[k].t3[0]-DTV[k].t1[0])/var[3];
						DTV[k].t3[1]=DTV[k].t1[1]+var[0]*(DTV[k].t3[1]-DTV[k].t1[1])/var[3];
					
					}
					
					if((var[0]>=0.0&&var[1]<0.0&&var[2]>=0.0)&&!check){
					check=1;
			var[3]=plan[0]*(DTV[k].v2[0]-DTV[k].v3[0])+plan[1]*(DTV[k].v2[1]-DTV[k].v3[1])+plan[2]*(DTV[k].v2[2]-DTV[k].v3[2]);
						DTV[k].v3[0]=DTV[k].v2[0]+var[1]*(DTV[k].v3[0]-DTV[k].v2[0])/var[3];
						DTV[k].v3[1]=DTV[k].v2[1]+var[1]*(DTV[k].v3[1]-DTV[k].v2[1])/var[3];
						DTV[k].v3[2]=DTV[k].v2[2]+var[1]*(DTV[k].v3[2]-DTV[k].v2[2])/var[3];
						
						DTV[k].n3[0]=DTV[k].n2[0]+var[1]*(DTV[k].n3[0]-DTV[k].n2[0])/var[3];
						DTV[k].n3[1]=DTV[k].n2[1]+var[1]*(DTV[k].n3[1]-DTV[k].n2[1])/var[3];
						DTV[k].n3[2]=DTV[k].n2[2]+var[1]*(DTV[k].n3[2]-DTV[k].n2[2])/var[3];
						var[4]=sqrt(DTV[k].n3[0]*DTV[k].n3[0]+DTV[k].n3[1]*DTV[k].n3[1]+DTV[k].n3[2]*DTV[k].n3[2]);
						DTV[k].n3[0]/=var[4];DTV[k].n3[1]/=var[4];DTV[k].n3[2]/=var[4];
						
						DTV[k].c3[0]=DTV[k].c2[0]+var[1]*(DTV[k].c3[0]-DTV[k].c2[0])/var[3];
						DTV[k].c3[1]=DTV[k].c2[1]+var[1]*(DTV[k].c3[1]-DTV[k].c2[1])/var[3];
						DTV[k].c3[2]=DTV[k].c2[2]+var[1]*(DTV[k].c3[2]-DTV[k].c2[2])/var[3];
						
						DTV[k].t3[0]=DTV[k].t2[0]+var[1]*(DTV[k].t3[0]-DTV[k].t2[0])/var[3];
						DTV[k].t3[1]=DTV[k].t2[1]+var[1]*(DTV[k].t3[1]-DTV[k].t2[1])/var[3];
						
			
			var[3]=plan[0]*(DTV[k].v2[0]-DTV[k].v1[0])+plan[1]*(DTV[k].v2[1]-DTV[k].v1[1])+plan[2]*(DTV[k].v2[2]-DTV[k].v1[2]);
						DTV[k].v1[0]=DTV[k].v2[0]+var[1]*(DTV[k].v1[0]-DTV[k].v2[0])/var[3];
						DTV[k].v1[1]=DTV[k].v2[1]+var[1]*(DTV[k].v1[1]-DTV[k].v2[1])/var[3];
						DTV[k].v1[2]=DTV[k].v2[2]+var[1]*(DTV[k].v1[2]-DTV[k].v2[2])/var[3];
						
						DTV[k].n1[0]=DTV[k].n2[0]+var[1]*(DTV[k].n1[0]-DTV[k].n2[0])/var[3];
						DTV[k].n1[1]=DTV[k].n2[1]+var[1]*(DTV[k].n1[1]-DTV[k].n2[1])/var[3];
						DTV[k].n1[2]=DTV[k].n2[2]+var[1]*(DTV[k].n1[2]-DTV[k].n2[2])/var[3];
						var[4]=sqrt(DTV[k].n1[0]*DTV[k].n1[0]+DTV[k].n1[1]*DTV[k].n1[1]+DTV[k].n1[2]*DTV[k].n1[2]);
						DTV[k].n1[0]/=var[4];DTV[k].n1[1]/=var[4];DTV[k].n1[2]/=var[4];
						
						DTV[k].c1[0]=DTV[k].c2[0]+var[1]*(DTV[k].c1[0]-DTV[k].c2[0])/var[3];
						DTV[k].c1[1]=DTV[k].c2[1]+var[1]*(DTV[k].c1[1]-DTV[k].c2[1])/var[3];
						DTV[k].c1[2]=DTV[k].c2[2]+var[1]*(DTV[k].c1[2]-DTV[k].c2[2])/var[3];
						
						DTV[k].t1[0]=DTV[k].t2[0]+var[1]*(DTV[k].t1[0]-DTV[k].t2[0])/var[3];
						DTV[k].t1[1]=DTV[k].t2[1]+var[1]*(DTV[k].t1[1]-DTV[k].t2[1])/var[3];
			
					
					}
					if((var[0]>=0.0&&var[1]>=0.0&&var[2]<0.0)&&!check){
					check=1;
			var[3]=plan[0]*(DTV[k].v3[0]-DTV[k].v1[0])+plan[1]*(DTV[k].v3[1]-DTV[k].v1[1])+plan[2]*(DTV[k].v3[2]-DTV[k].v1[2]);
						DTV[k].v1[0]=DTV[k].v3[0]+var[2]*(DTV[k].v1[0]-DTV[k].v3[0])/var[3];
						DTV[k].v1[1]=DTV[k].v3[1]+var[2]*(DTV[k].v1[1]-DTV[k].v3[1])/var[3];
						DTV[k].v1[2]=DTV[k].v3[2]+var[2]*(DTV[k].v1[2]-DTV[k].v3[2])/var[3];
					
						DTV[k].n1[0]=DTV[k].n3[0]+var[2]*(DTV[k].n1[0]-DTV[k].n3[0])/var[3];
						DTV[k].n1[1]=DTV[k].n3[1]+var[2]*(DTV[k].n1[1]-DTV[k].n3[1])/var[3];
						DTV[k].n1[2]=DTV[k].n3[2]+var[2]*(DTV[k].n1[2]-DTV[k].n3[2])/var[3];
						var[4]=sqrt(DTV[k].n1[0]*DTV[k].n1[0]+DTV[k].n1[1]*DTV[k].n1[1]+DTV[k].n1[2]*DTV[k].n1[2]);
						DTV[k].n1[0]/=var[4];DTV[k].n1[1]/=var[4];DTV[k].n1[2]/=var[4];
						
						DTV[k].c1[0]=DTV[k].c3[0]+var[2]*(DTV[k].c1[0]-DTV[k].c3[0])/var[3];
						DTV[k].c1[1]=DTV[k].c3[1]+var[2]*(DTV[k].c1[1]-DTV[k].c3[1])/var[3];
						DTV[k].c1[2]=DTV[k].c3[2]+var[2]*(DTV[k].c1[2]-DTV[k].c3[2])/var[3];
						
						DTV[k].t1[0]=DTV[k].t3[0]+var[2]*(DTV[k].t1[0]-DTV[k].t3[0])/var[3];
						DTV[k].t1[1]=DTV[k].t3[1]+var[2]*(DTV[k].t1[1]-DTV[k].t3[1])/var[3];
						
			
			var[3]=plan[0]*(DTV[k].v3[0]-DTV[k].v2[0])+plan[1]*(DTV[k].v3[1]-DTV[k].v2[1])+plan[2]*(DTV[k].v3[2]-DTV[k].v2[2]);
						DTV[k].v2[0]=DTV[k].v3[0]+var[2]*(DTV[k].v2[0]-DTV[k].v3[0])/var[3];
						DTV[k].v2[1]=DTV[k].v3[1]+var[2]*(DTV[k].v2[1]-DTV[k].v3[1])/var[3];
						DTV[k].v2[2]=DTV[k].v3[2]+var[2]*(DTV[k].v2[2]-DTV[k].v3[2])/var[3];
						
						DTV[k].n2[0]=DTV[k].n3[0]+var[2]*(DTV[k].n2[0]-DTV[k].n3[0])/var[3];
						DTV[k].n2[1]=DTV[k].n3[1]+var[2]*(DTV[k].n2[1]-DTV[k].n3[1])/var[3];
						DTV[k].n2[2]=DTV[k].n3[2]+var[2]*(DTV[k].n2[2]-DTV[k].n3[2])/var[3];
						var[4]=sqrt(DTV[k].n2[0]*DTV[k].n2[0]+DTV[k].n2[1]*DTV[k].n2[1]+DTV[k].n2[2]*DTV[k].n2[2]);
						DTV[k].n2[0]/=var[4];DTV[k].n2[1]/=var[4];DTV[k].n2[2]/=var[4];
						
						DTV[k].c2[0]=DTV[k].c3[0]+var[2]*(DTV[k].c2[0]-DTV[k].c3[0])/var[3];
						DTV[k].c2[1]=DTV[k].c3[1]+var[2]*(DTV[k].c2[1]-DTV[k].c3[1])/var[3];
						DTV[k].c2[2]=DTV[k].c3[2]+var[2]*(DTV[k].c2[2]-DTV[k].c3[2])/var[3];
						
						DTV[k].t2[0]=DTV[k].t3[0]+var[2]*(DTV[k].t2[0]-DTV[k].t3[0])/var[3];
						DTV[k].t2[1]=DTV[k].t3[1]+var[2]*(DTV[k].t2[1]-DTV[k].t3[1])/var[3];
			
					
					}
					
					if((var[0]<=0.0&&var[1]>0.0&&var[2]<=0.0)&&!check){
					check=1;
			var[3]=plan[0]*(DTV[k].v2[0]-DTV[k].v3[0])+plan[1]*(DTV[k].v2[1]-DTV[k].v3[1])+plan[2]*(DTV[k].v2[2]-DTV[k].v3[2]);
			tempo[0]=DTV[k].v2[0];tempo[1]=DTV[k].v2[1];tempo[2]=DTV[k].v2[2];
			tempon[0]=DTV[k].n2[0];tempon[1]=DTV[k].n2[1];tempon[2]=DTV[k].n2[2];
			tempoc[0]=DTV[k].c2[0];tempoc[1]=DTV[k].c2[1];tempoc[2]=DTV[k].c2[2];
			tempot[0]=DTV[k].t2[0];tempot[1]=DTV[k].t2[1];tempot[2]=DTV[k].t2[2];
						DTV[k].v2[0]=DTV[k].v2[0]+var[1]*(DTV[k].v3[0]-DTV[k].v2[0])/var[3];
						DTV[k].v2[1]=DTV[k].v2[1]+var[1]*(DTV[k].v3[1]-DTV[k].v2[1])/var[3];
						DTV[k].v2[2]=DTV[k].v2[2]+var[1]*(DTV[k].v3[2]-DTV[k].v2[2])/var[3];
						
						DTV[k].n2[0]=DTV[k].n2[0]+var[1]*(DTV[k].n3[0]-DTV[k].n2[0])/var[3];
						DTV[k].n2[1]=DTV[k].n2[1]+var[1]*(DTV[k].n3[1]-DTV[k].n2[1])/var[3];
						DTV[k].n2[2]=DTV[k].n2[2]+var[1]*(DTV[k].n3[2]-DTV[k].n2[2])/var[3];
						var[4]=sqrt(DTV[k].n2[0]*DTV[k].n2[0]+DTV[k].n2[1]*DTV[k].n2[1]+DTV[k].n2[2]*DTV[k].n2[2]);
						DTV[k].n2[0]/=var[4];DTV[k].n2[1]/=var[4];DTV[k].n2[2]/=var[4];
			
						DTV[k].c2[0]=DTV[k].c2[0]+var[1]*(DTV[k].c3[0]-DTV[k].c2[0])/var[3];
						DTV[k].c2[1]=DTV[k].c2[1]+var[1]*(DTV[k].c3[1]-DTV[k].c2[1])/var[3];
						DTV[k].c2[2]=DTV[k].c2[2]+var[1]*(DTV[k].c3[2]-DTV[k].c2[2])/var[3];
			
						DTV[k].t2[0]=DTV[k].t2[0]+var[1]*(DTV[k].t3[0]-DTV[k].t2[0])/var[3];
						DTV[k].t2[1]=DTV[k].t2[1]+var[1]*(DTV[k].t3[1]-DTV[k].t2[1])/var[3];
						
			j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			var[3]=plan[0]*(tempo[0]-DTV[k].v1[0])+plan[1]*(tempo[1]-DTV[k].v1[1])+plan[2]*(tempo[2]-DTV[k].v1[2]);
						DTV[j].v2[0]=tempo[0]+var[1]*(DTV[k].v1[0]-tempo[0])/var[3];
						DTV[j].v2[1]=tempo[1]+var[1]*(DTV[k].v1[1]-tempo[1])/var[3];
						DTV[j].v2[2]=tempo[2]+var[1]*(DTV[k].v1[2]-tempo[2])/var[3];
						
						DTV[j].n2[0]=tempon[0]+var[1]*(DTV[k].n1[0]-tempon[0])/var[3];
						DTV[j].n2[1]=tempon[1]+var[1]*(DTV[k].n1[1]-tempon[1])/var[3];
						DTV[j].n2[2]=tempon[2]+var[1]*(DTV[k].n1[2]-tempon[2])/var[3];
						var[4]=sqrt(DTV[j].n2[0]*DTV[j].n2[0]+DTV[j].n2[1]*DTV[j].n2[1]+DTV[j].n2[2]*DTV[j].n2[2]);
						DTV[j].n2[0]/=var[4];DTV[j].n2[1]/=var[4];DTV[j].n2[2]/=var[4];
						
						DTV[j].c2[0]=tempoc[0]+var[1]*(DTV[k].c1[0]-tempoc[0])/var[3];
						DTV[j].c2[1]=tempoc[1]+var[1]*(DTV[k].c1[1]-tempoc[1])/var[3];
						DTV[j].c2[2]=tempoc[2]+var[1]*(DTV[k].c1[2]-tempoc[2])/var[3];
						
						DTV[j].t2[0]=tempot[0]+var[1]*(DTV[k].t1[0]-tempot[0])/var[3];
						DTV[j].t2[1]=tempot[1]+var[1]*(DTV[k].t1[1]-tempot[1])/var[3];
			
						DTV[j].texture=DTV[k].texture;
						DTV[j].v1[0]=DTV[k].v1[0];DTV[j].v1[1]=DTV[k].v1[1];DTV[j].v1[2]=DTV[k].v1[2];
						DTV[j].v3[0]=DTV[k].v2[0];DTV[j].v3[1]=DTV[k].v2[1];DTV[j].v3[2]=DTV[k].v2[2];
						
						DTV[j].n1[0]=DTV[k].n1[0];DTV[j].n1[1]=DTV[k].n1[1];DTV[j].n1[2]=DTV[k].n1[2];
						DTV[j].n3[0]=DTV[k].n2[0];DTV[j].n3[1]=DTV[k].n2[1];DTV[j].n3[2]=DTV[k].n2[2];
						
						DTV[j].c1[0]=DTV[k].c1[0];DTV[j].c1[1]=DTV[k].c1[1];DTV[j].c1[2]=DTV[k].c1[2];
						DTV[j].c3[0]=DTV[k].c2[0];DTV[j].c3[1]=DTV[k].c2[1];DTV[j].c3[2]=DTV[k].c2[2];
						
						DTV[j].t1[0]=DTV[k].t1[0];DTV[j].t1[1]=DTV[k].t1[1];
						DTV[j].t3[0]=DTV[k].t2[0];DTV[j].t3[1]=DTV[k].t2[1];
						
						
					}
					
					if((var[0]>0.0&&var[1]<=0.0&&var[2]<=0.0)&&!check){
					check=1;
			var[3]=plan[0]*(DTV[k].v1[0]-DTV[k].v2[0])+plan[1]*(DTV[k].v1[1]-DTV[k].v2[1])+plan[2]*(DTV[k].v1[2]-DTV[k].v2[2]);
			tempo[0]=DTV[k].v1[0];tempo[1]=DTV[k].v1[1];tempo[2]=DTV[k].v1[2];
			tempon[0]=DTV[k].n1[0];tempon[1]=DTV[k].n1[1];tempon[2]=DTV[k].n1[2];
			tempoc[0]=DTV[k].c1[0];tempoc[1]=DTV[k].c1[1];tempoc[2]=DTV[k].c1[2];
			tempot[0]=DTV[k].t1[0];tempot[1]=DTV[k].t1[1];tempot[2]=DTV[k].t1[2];
						DTV[k].v1[0]=DTV[k].v1[0]+var[0]*(DTV[k].v2[0]-DTV[k].v1[0])/var[3];
						DTV[k].v1[1]=DTV[k].v1[1]+var[0]*(DTV[k].v2[1]-DTV[k].v1[1])/var[3];
						DTV[k].v1[2]=DTV[k].v1[2]+var[0]*(DTV[k].v2[2]-DTV[k].v1[2])/var[3];
			
						DTV[k].n1[0]=DTV[k].n1[0]+var[0]*(DTV[k].n2[0]-DTV[k].n1[0])/var[3];
						DTV[k].n1[1]=DTV[k].n1[1]+var[0]*(DTV[k].n2[1]-DTV[k].n1[1])/var[3];
						DTV[k].n1[2]=DTV[k].n1[2]+var[0]*(DTV[k].n2[2]-DTV[k].n1[2])/var[3];
						var[4]=sqrt(DTV[k].n1[0]*DTV[k].n1[0]+DTV[k].n1[1]*DTV[k].n1[1]+DTV[k].n1[2]*DTV[k].n1[2]);
						DTV[k].n1[0]/=var[4];DTV[k].n1[1]/=var[4];DTV[k].n1[2]/=var[4];
						
						DTV[k].c1[0]=DTV[k].c1[0]+var[0]*(DTV[k].c2[0]-DTV[k].c1[0])/var[3];
						DTV[k].c1[1]=DTV[k].c1[1]+var[0]*(DTV[k].c2[1]-DTV[k].c1[1])/var[3];
						DTV[k].c1[2]=DTV[k].c1[2]+var[0]*(DTV[k].c2[2]-DTV[k].c1[2])/var[3];
						
						DTV[k].t1[0]=DTV[k].t1[0]+var[0]*(DTV[k].t2[0]-DTV[k].t1[0])/var[3];
						DTV[k].t1[1]=DTV[k].t1[1]+var[0]*(DTV[k].t2[1]-DTV[k].t1[1])/var[3];
						
			j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			var[3]=plan[0]*(tempo[0]-DTV[k].v3[0])+plan[1]*(tempo[1]-DTV[k].v3[1])+plan[2]*(tempo[2]-DTV[k].v3[2]);
						DTV[j].v1[0]=tempo[0]+var[0]*(DTV[k].v3[0]-tempo[0])/var[3];
						DTV[j].v1[1]=tempo[1]+var[0]*(DTV[k].v3[1]-tempo[1])/var[3];
						DTV[j].v1[2]=tempo[2]+var[0]*(DTV[k].v3[2]-tempo[2])/var[3];
						
						DTV[j].n1[0]=tempon[0]+var[0]*(DTV[k].n3[0]-tempon[0])/var[3];
						DTV[j].n1[1]=tempon[1]+var[0]*(DTV[k].n3[1]-tempon[1])/var[3];
						DTV[j].n1[2]=tempon[2]+var[0]*(DTV[k].n3[2]-tempon[2])/var[3];
						var[4]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
						DTV[j].n1[0]/=var[4];DTV[j].n1[1]/=var[4];DTV[j].n1[2]/=var[4];
						
						DTV[j].c1[0]=tempoc[0]+var[0]*(DTV[k].c3[0]-tempoc[0])/var[3];
						DTV[j].c1[1]=tempoc[1]+var[0]*(DTV[k].c3[1]-tempoc[1])/var[3];
						DTV[j].c1[2]=tempoc[2]+var[0]*(DTV[k].c3[2]-tempoc[2])/var[3];
						
						DTV[j].t1[0]=tempot[0]+var[0]*(DTV[k].t3[0]-tempot[0])/var[3];
						DTV[j].t1[1]=tempot[1]+var[0]*(DTV[k].t3[1]-tempot[1])/var[3];
						DTV[j].texture=DTV[k].texture;
						DTV[j].v2[0]=DTV[k].v1[0];DTV[j].v2[1]=DTV[k].v1[1];DTV[j].v2[2]=DTV[k].v1[2];
						DTV[j].v3[0]=DTV[k].v3[0];DTV[j].v3[1]=DTV[k].v3[1];DTV[j].v3[2]=DTV[k].v3[2];
						
						DTV[j].n2[0]=DTV[k].n1[0];DTV[j].n2[1]=DTV[k].n1[1];DTV[j].n2[2]=DTV[k].n1[2];
						DTV[j].n3[0]=DTV[k].n3[0];DTV[j].n3[1]=DTV[k].n3[1];DTV[j].n3[2]=DTV[k].n3[2];
						
						DTV[j].c2[0]=DTV[k].c1[0];DTV[j].c2[1]=DTV[k].c1[1];DTV[j].c2[2]=DTV[k].c1[2];
						DTV[j].c3[0]=DTV[k].c3[0];DTV[j].c3[1]=DTV[k].c3[1];DTV[j].c3[2]=DTV[k].c3[2];
						
						DTV[j].t2[0]=DTV[k].t1[0];DTV[j].t2[1]=DTV[k].t1[1];
						DTV[j].t3[0]=DTV[k].t3[0];DTV[j].t3[1]=DTV[k].t3[1];
					
					
					}
					
					if((var[0]<=0.0&&var[1]<=0.0&&var[2]>0.0)&&!check){
					check=1;
			/*/SendText(QString("entro aqui"));*/
			var[3]=plan[0]*(DTV[k].v3[0]-DTV[k].v1[0])+plan[1]*(DTV[k].v3[1]-DTV[k].v1[1])+plan[2]*(DTV[k].v3[2]-DTV[k].v1[2]);
			tempo[0]=DTV[k].v3[0];tempo[1]=DTV[k].v3[1];tempo[2]=DTV[k].v3[2];
			tempon[0]=DTV[k].n3[0];tempon[1]=DTV[k].n3[1];tempon[2]=DTV[k].n3[2];
			tempoc[0]=DTV[k].c3[0];tempoc[1]=DTV[k].c3[1];tempoc[2]=DTV[k].c3[2];
			tempot[0]=DTV[k].t3[0];tempot[1]=DTV[k].t3[1];tempot[2]=DTV[k].t3[2];
						DTV[k].v3[0]=DTV[k].v3[0]+var[2]*(DTV[k].v1[0]-DTV[k].v3[0])/var[3];
						DTV[k].v3[1]=DTV[k].v3[1]+var[2]*(DTV[k].v1[1]-DTV[k].v3[1])/var[3];
						DTV[k].v3[2]=DTV[k].v3[2]+var[2]*(DTV[k].v1[2]-DTV[k].v3[2])/var[3];
					
						DTV[k].n3[0]=DTV[k].n3[0]+var[2]*(DTV[k].n1[0]-DTV[k].n3[0])/var[3];
						DTV[k].n3[1]=DTV[k].n3[1]+var[2]*(DTV[k].n1[1]-DTV[k].n3[1])/var[3];
						DTV[k].n3[2]=DTV[k].n3[2]+var[2]*(DTV[k].n1[2]-DTV[k].n3[2])/var[3];
						var[4]=sqrt(DTV[k].n3[0]*DTV[k].n3[0]+DTV[k].n3[1]*DTV[k].n3[1]+DTV[k].n3[2]*DTV[k].n3[2]);
						DTV[k].n3[0]/=var[4];DTV[k].n3[1]/=var[4];DTV[k].n3[2]/=var[4];
						
						DTV[k].c3[0]=DTV[k].c3[0]+var[2]*(DTV[k].c1[0]-DTV[k].c3[0])/var[3];
						DTV[k].c3[1]=DTV[k].c3[1]+var[2]*(DTV[k].c1[1]-DTV[k].c3[1])/var[3];
						DTV[k].c3[2]=DTV[k].c3[2]+var[2]*(DTV[k].c1[2]-DTV[k].c3[2])/var[3];
						
						DTV[k].t3[0]=DTV[k].t3[0]+var[2]*(DTV[k].t1[0]-DTV[k].t3[0])/var[3];
						DTV[k].t3[1]=DTV[k].t3[1]+var[2]*(DTV[k].t1[1]-DTV[k].t3[1])/var[3];
						
			j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			var[3]=plan[0]*(tempo[0]-DTV[k].v2[0])+plan[1]*(tempo[1]-DTV[k].v2[1])+plan[2]*(tempo[2]-DTV[k].v2[2]);
						DTV[j].v3[0]=tempo[0]+var[2]*(DTV[k].v2[0]-tempo[0])/var[3];
						DTV[j].v3[1]=tempo[1]+var[2]*(DTV[k].v2[1]-tempo[1])/var[3];
						DTV[j].v3[2]=tempo[2]+var[2]*(DTV[k].v2[2]-tempo[2])/var[3];
						
						DTV[j].n3[0]=tempon[0]+var[2]*(DTV[k].n2[0]-tempon[0])/var[3];
						DTV[j].n3[1]=tempon[1]+var[2]*(DTV[k].n2[1]-tempon[1])/var[3];
						DTV[j].n3[2]=tempon[2]+var[2]*(DTV[k].n2[2]-tempon[2])/var[3];
						var[4]=sqrt(DTV[j].n3[0]*DTV[j].n3[0]+DTV[j].n3[1]*DTV[j].n3[1]+DTV[j].n3[2]*DTV[j].n3[2]);
						DTV[j].n3[0]/=var[4];DTV[j].n3[1]/=var[4];DTV[j].n3[2]/=var[4];
						
						DTV[j].c3[0]=tempoc[0]+var[2]*(DTV[k].c2[0]-tempoc[0])/var[3];
						DTV[j].c3[1]=tempoc[1]+var[2]*(DTV[k].c2[1]-tempoc[1])/var[3];
						DTV[j].c3[2]=tempoc[2]+var[2]*(DTV[k].c2[2]-tempoc[2])/var[3];
						
						DTV[j].t3[0]=tempot[0]+var[2]*(DTV[k].t2[0]-tempot[0])/var[3];
						DTV[j].t3[1]=tempot[1]+var[2]*(DTV[k].t2[1]-tempot[1])/var[3];
						DTV[j].texture=DTV[k].texture;
						DTV[j].v1[0]=DTV[k].v3[0];DTV[j].v1[1]=DTV[k].v3[1];DTV[j].v1[2]=DTV[k].v3[2];
						DTV[j].v2[0]=DTV[k].v2[0];DTV[j].v2[1]=DTV[k].v2[1];DTV[j].v2[2]=DTV[k].v2[2];
						
						DTV[j].n1[0]=DTV[k].n3[0];DTV[j].n1[1]=DTV[k].n3[1];DTV[j].n1[2]=DTV[k].n3[2];
						DTV[j].n2[0]=DTV[k].n2[0];DTV[j].n2[1]=DTV[k].n2[1];DTV[j].n2[2]=DTV[k].n2[2];
						
						DTV[j].c1[0]=DTV[k].c3[0];DTV[j].c1[1]=DTV[k].c3[1];DTV[j].c1[2]=DTV[k].c3[2];
						DTV[j].c2[0]=DTV[k].c2[0];DTV[j].c2[1]=DTV[k].c2[1];DTV[j].c2[2]=DTV[k].c2[2];
						
						DTV[j].t1[0]=DTV[k].t3[0];DTV[j].t1[1]=DTV[k].t3[1];
						DTV[j].t2[0]=DTV[k].t2[0];DTV[j].t2[1]=DTV[k].t2[1];
					}
					
					
						
					
					}/*if(type==2)*/
				}/*else*/
			}/*ciclo DataSV*/
			DataSV.resize(w);
			SecCmd="";step=1;
			cmdquickerase();
			CmdCancel();
			return;
			}
		break;

	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
