/****************************************************************************
** $Id:  cmds/cmdrotate3d.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDROTATE3D_H
#define CMDROTATE3D_H
#include "cmds.h"


void cmds::cmdrotate3d(){
	int i,j,k;
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	double var[3];
	var[0]=var[1]=var[2]=0;
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Rotate3d--"));instruction=tr("Rotate [Base point/X/Y/Z]<Z>:");emit instru(instruction);
				tempdataI[0]=0;tempdataF[0]=0;tempdataF[1]=0;tempdataF[2]=0;tempdataF[3]=1;tempdataF[4]=0;tempdataI[1]=2;
				rtlines->v[0]=0;GriPoint->v[0]=0;rtlines->v[1]=0;GriPoint->v[1]=0;rtlines->v[2]=0;GriPoint->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				step++;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			/*if(!SecCmd.compare(tr("c","Copy"))||!SecCmd.compare(tr("C","Copy"))){
				tempdataI[0]=1;
				SendText(tr("Copy"));
				return;
			}*/
			if(!SecCmd.compare("x")||!SecCmd.compare("X")){
				tempdataI[1]=0;
				instruction=tr("Rotate [Base point/X/Y/Z]<X>:");emit instru(instruction);
				SendText("X");
				return;
			}
			if(!SecCmd.compare("y")||!SecCmd.compare("Y")){
				tempdataI[1]=1;
				instruction=tr("Rotate [Base point/X/Y/Z]<Y>:");emit instru(instruction);
				SendText("Y");
				return;
			}
			if(!SecCmd.compare(tr("z","Plane Z"))||!SecCmd.compare(tr("Z","Plane Z"))){
				tempdataI[1]=2;
				instruction=tr("Rotate [Base point/X/Y/Z]<Z>:");emit instru(instruction);
				SendText("Z");
				return;
			}

			
			if(!SecCmd.compare(tr("b"))||!SecCmd.compare(tr("B"))){
				SendText(tr("Base point"));emit instru(tr("Rotate (Base point):"));
				rtlines[0].find=0;
				step=2;
				return;
			}
			if(!SecCmd.compare("setCmdData")&&tempdataI[1]==0){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
					
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==2){
					var[0]=cosf(currentdata.v[0]*M_PI/180.0);var[1]=sinf(currentdata.v[0]*M_PI/180.0);
					var[2]=1;
				}
				if(var[2]){
				
					for(i=0,j=0,k=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							k=DataSV[i].index;
							tempdataF[1]=DLV[k].v1[1]-GriPoint->v[1];
							tempdataF[2]=DLV[k].v1[2]-GriPoint->v[2];
							DLV[k].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DLV[k].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];

							tempdataF[1]=DLV[k].v2[1]-GriPoint->v[1];
							tempdataF[2]=DLV[k].v2[2]-GriPoint->v[2];
							DLV[k].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DLV[k].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
						}
						
						if(DataSV[i].type==2){
							k=DataSV[i].index;
							tempdataF[1]=DTV[k].v1[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v1[2]-GriPoint->v[2];
							DTV[k].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
							tempdataF[1]=DTV[k].v2[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v2[2]-GriPoint->v[2];
							DTV[k].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
							tempdataF[1]=DTV[k].v3[1]-GriPoint->v[1];
							tempdataF[2]=DTV[k].v3[2]-GriPoint->v[2];
							DTV[k].v3[1]=GriPoint->v[1]+(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v3[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
							tempdataF[0]=DTV[k].n1[0];tempdataF[1]=DTV[k].n1[1];tempdataF[2]=DTV[k].n1[2];
							DTV[k].n1[0]=tempdataF[0];
							DTV[k].n1[1]=(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n1[2]=(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
							tempdataF[0]=DTV[k].n2[0];tempdataF[1]=DTV[k].n2[1];tempdataF[2]=DTV[k].n2[2];
							DTV[k].n2[0]=tempdataF[0];
							DTV[k].n2[1]=(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n2[2]=(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
							tempdataF[0]=DTV[k].n3[0];tempdataF[1]=DTV[k].n3[1];tempdataF[2]=DTV[k].n3[2];
							DTV[k].n3[0]=tempdataF[0];
							DTV[k].n3[1]=(tempdataF[1]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n3[2]=(tempdataF[2]*var[0]+tempdataF[1]*var[1])/var[2];
						
						
						}

					}

				}

			CmdCancel();
			return;
			}
			
			if(!SecCmd.compare("setCmdData")&&tempdataI[1]==1){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
					
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==2){
					var[0]=cosf(currentdata.v[0]*M_PI/180.0);var[1]=sinf(currentdata.v[0]*M_PI/180.0);
					var[2]=1;
				}
				if(var[2]){
				
					for(i=0,j=0,k=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							k=DataSV[i].index;
							tempdataF[0]=DLV[k].v1[0]-GriPoint->v[0];
							tempdataF[2]=DLV[k].v1[2]-GriPoint->v[2];
							DLV[k].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DLV[k].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DLV[k].v2[0]-GriPoint->v[0];
							tempdataF[2]=DLV[k].v2[2]-GriPoint->v[2];
							DLV[k].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DLV[k].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
						}
						
						
						if(DataSV[i].type==2){
							k=DataSV[i].index;
							tempdataF[0]=DTV[k].v1[0]-GriPoint->v[0];
							tempdataF[2]=DTV[k].v1[2]-GriPoint->v[2];
							DTV[k].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v1[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].v2[0]-GriPoint->v[0];
							tempdataF[2]=DTV[k].v2[2]-GriPoint->v[2];
							DTV[k].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v2[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].v3[0]-GriPoint->v[0];
							tempdataF[2]=DTV[k].v3[2]-GriPoint->v[2];
							DTV[k].v3[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].v3[2]=GriPoint->v[2]+(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].n1[0];tempdataF[1]=DTV[k].n1[1];tempdataF[2]=DTV[k].n1[2];
							DTV[k].n1[0]=(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n1[1]=tempdataF[1];
							DTV[k].n1[2]=(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].n2[0];tempdataF[1]=DTV[k].n2[1];tempdataF[2]=DTV[k].n2[2];
							DTV[k].n2[0]=(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n2[1]=tempdataF[1];
							DTV[k].n2[2]=(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].n3[0];tempdataF[1]=DTV[k].n3[1];tempdataF[2]=DTV[k].n3[2];
							DTV[k].n3[0]=(tempdataF[0]*var[0]-tempdataF[2]*var[1])/var[2];
							DTV[k].n3[1]=tempdataF[1];
							DTV[k].n3[2]=(tempdataF[2]*var[0]+tempdataF[0]*var[1])/var[2];
						}

					}

				}

			CmdCancel();
			return;
			}
			
			
			if(!SecCmd.compare("setCmdData")&&tempdataI[1]==2){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
					
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==2){
					var[0]=cosf(currentdata.v[0]*M_PI/180.0);var[1]=sinf(currentdata.v[0]*M_PI/180.0);
					var[2]=1;
				}
				if(var[2]){
				
					for(i=0,j=0,k=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							k=DataSV[i].index;
							tempdataF[0]=DLV[k].v1[0]-GriPoint->v[0];
							tempdataF[1]=DLV[k].v1[1]-GriPoint->v[1];
							DLV[k].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DLV[k].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DLV[k].v2[0]-GriPoint->v[0];
							tempdataF[1]=DLV[k].v2[1]-GriPoint->v[1];
							DLV[k].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DLV[k].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
						}
						
						if(DataSV[i].type==2){
							k=DataSV[i].index;
							tempdataF[0]=DTV[k].v1[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v1[1]-GriPoint->v[1];
							DTV[k].v1[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].v1[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].v2[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v2[1]-GriPoint->v[1];
							DTV[k].v2[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].v2[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].v3[0]-GriPoint->v[0];
							tempdataF[1]=DTV[k].v3[1]-GriPoint->v[1];
							DTV[k].v3[0]=GriPoint->v[0]+(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].v3[1]=GriPoint->v[1]+(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							tempdataF[0]=DTV[k].n1[0];tempdataF[1]=DTV[k].n1[1];tempdataF[2]=DTV[k].n1[2];
							DTV[k].n1[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].n1[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[k].n1[2]=tempdataF[2];
							tempdataF[0]=DTV[k].n2[0];tempdataF[1]=DTV[k].n2[1];tempdataF[2]=DTV[k].n2[2];
							DTV[k].n2[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].n2[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[k].n2[2]=tempdataF[2];
							tempdataF[0]=DTV[k].n3[0];tempdataF[1]=DTV[k].n3[1];tempdataF[2]=DTV[k].n3[2];
							DTV[k].n3[0]=(tempdataF[0]*var[0]-tempdataF[1]*var[1])/var[2];
							DTV[k].n3[1]=(tempdataF[1]*var[0]+tempdataF[0]*var[1])/var[2];
							DTV[k].n3[2]=tempdataF[2];
						
						
						}

					}

				}

			CmdCancel();
			return;
			}
			
		break;
		case 2: /*SET BASE POINT STATE*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					GriPoint->v[0]=currentdata.v[0];GriPoint->v[1]=currentdata.v[1];GriPoint->v[2]=currentdata.v[2];
				}
				if(currentdata.format==1){
					GriPoint->v[0]+=currentdata.v[0];GriPoint->v[1]+=currentdata.v[1];GriPoint->v[2]+=currentdata.v[2];
				}
				var[0]=tempdataF[3];var[1]=tempdataF[4];var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				if(var[2]){
				
				rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				}
			emit instru(instruction);
			step=1;
			return;
			}
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
