/****************************************************************************
** $Id:  cmds/cmdextrude.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDEXTRUDE_H
#define CMDEXTRUDE_H
#include "cmds.h"


void cmds::cmdextrude(){
	int i,j,k;
	float var[1];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**"))&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			tempdataF[6]=1.0;
			SendText(tr("Extrude"));
			instruction=QString(tr("Extrude [Height<%1>]")).arg(tempdataF[6]);emit instru(instruction);
			step++;
			return;
		break;
		case 1:
		instruction=QString(tr("Extrude [Height<%1>]")).arg(tempdataF[6]);emit instru(instruction);
		if(CmdSelectPopView()){return;}
		
		if(!SecCmd.compare(tr("h","Height"))||!SecCmd.compare(tr("H","Height"))){
			SendText(tr("Height"));emit instru(tr("Extrude (Height):"));
			step++;
			return;
		}
			
		if(!SecCmd.compare("MouseRButton")||!SecCmd.compare("")){
			if(DataSV.size()){
			for(i=0;i<DataSV.size();i++){
				if(DataSV[i].type==1){
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();k=DataSV[i].index;
					DTV[j].v1[0]=DLV[k].v1[0];DTV[j].v1[1]=DLV[k].v1[1];DTV[j].v1[2]=DLV[k].v1[2];
					DTV[j].c1[0]=DLV[k].c1[0];DTV[j].c1[1]=DLV[k].c1[1];DTV[j].c1[2]=DLV[k].c1[2];
					
					DTV[j].v2[0]=DLV[k].v2[0];DTV[j].v2[1]=DLV[k].v2[1];DTV[j].v2[2]=DLV[k].v2[2];
					DTV[j].c2[0]=DLV[k].c2[0];DTV[j].c2[1]=DLV[k].c2[1];DTV[j].c2[2]=DLV[k].c2[2];
					
					DTV[j].v3[0]=DLV[k].v2[0];DTV[j].v3[1]=DLV[k].v2[1];DTV[j].v3[2]=DLV[k].v2[2]+tempdataF[6];
					DTV[j].c3[0]=DLV[k].c2[0];DTV[j].c3[1]=DLV[k].c2[1];DTV[j].c3[2]=DLV[k].c2[2];
					
					DTV[j].texture=0;
					
				tempdataF[0]=DTV[j].v2[0]-DTV[j].v1[0];
				tempdataF[1]=DTV[j].v2[1]-DTV[j].v1[1];
				tempdataF[2]=DTV[j].v2[2]-DTV[j].v1[2];
				tempdataF[3]=DTV[j].v3[0]-DTV[j].v1[0];
				tempdataF[4]=DTV[j].v3[1]-DTV[j].v1[1];
				tempdataF[5]=DTV[j].v3[2]-DTV[j].v1[2];
				
				DTV[j].n3[0]=DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
				DTV[j].n3[1]=DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
				DTV[j].n3[2]=DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
				DTV[j].n3[0]/=var[0];DTV[j].n2[0]/=var[0];DTV[j].n1[0]/=var[0];
				DTV[j].n3[1]/=var[0];DTV[j].n2[1]/=var[0];DTV[j].n1[1]/=var[0];
				DTV[j].n3[2]/=var[0];DTV[j].n2[2]/=var[0];DTV[j].n1[2]/=var[0];
					
					
					
					
					j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
					DTV[j].v1[0]=DLV[k].v2[0];DTV[j].v1[1]=DLV[k].v2[1];DTV[j].v1[2]=DLV[k].v2[2]+tempdataF[6];
					DTV[j].c1[0]=DLV[k].c2[0];DTV[j].c1[1]=DLV[k].c2[1];DTV[j].c1[2]=DLV[k].c2[2];
					
					DTV[j].v2[0]=DLV[k].v1[0];DTV[j].v2[1]=DLV[k].v1[1];DTV[j].v2[2]=DLV[k].v1[2]+tempdataF[6];
					DTV[j].c2[0]=DLV[k].c1[0];DTV[j].c2[1]=DLV[k].c1[1];DTV[j].c2[2]=DLV[k].c1[2];
					
					DTV[j].v3[0]=DLV[k].v1[0];DTV[j].v3[1]=DLV[k].v1[1];DTV[j].v3[2]=DLV[k].v1[2];
					DTV[j].c3[0]=DLV[k].c1[0];DTV[j].c3[1]=DLV[k].c1[1];DTV[j].c3[2]=DLV[k].c1[2];
					
					DTV[j].texture=0;
				tempdataF[0]=DTV[j].v2[0]-DTV[j].v1[0];
				tempdataF[1]=DTV[j].v2[1]-DTV[j].v1[1];
				tempdataF[2]=DTV[j].v2[2]-DTV[j].v1[2];
				tempdataF[3]=DTV[j].v3[0]-DTV[j].v1[0];
				tempdataF[4]=DTV[j].v3[1]-DTV[j].v1[1];
				tempdataF[5]=DTV[j].v3[2]-DTV[j].v1[2];
				
				DTV[j].n3[0]=DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
				DTV[j].n3[1]=DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
				DTV[j].n3[2]=DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
				DTV[j].n3[0]/=var[0];DTV[j].n2[0]/=var[0];DTV[j].n1[0]/=var[0];
				DTV[j].n3[1]/=var[0];DTV[j].n2[1]/=var[0];DTV[j].n1[1]/=var[0];
				DTV[j].n3[2]/=var[0];DTV[j].n2[2]/=var[0];DTV[j].n1[2]/=var[0];
				}
		
		
			
			}
			cmdquickerase();
			CmdCancel();
			return;
			}
			
		}
		break;
		case 2:
		if(CmdSelectPopView()){return;}
		if(!SecCmd.compare("MouseRButton")||!SecCmd.compare("")){
			instruction=QString(tr("Extrude [Height<%1>]")).arg(tempdataF[6]);emit instru(instruction);
			step=1;
			return;
		}
		if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						tempdataF[6]=currentdata.v[0];
						instruction=QString(tr("Extrude [Height<%1>]")).arg(tempdataF[6]);emit instru(instruction);
						step=1;
						return;
				}
		}
		break;

	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
