/****************************************************************************
** $Id:  cmds/cmddist.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDDIST_H
#define CMDDIST_H
#include "cmds.h"


void cmds::cmddist(){
	double var[4];
	var[0]=var[1]=var[2]=0;
	if((SecCmd==tr("**Cancel**")||SecCmd==""||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(tr("--Distance--"));
				instruction=tr("Distance pickpoint 1:");emit instru(instruction);
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				tempdataF[0]=rtlines[0].v[0];tempdataF[1]=rtlines[0].v[1];tempdataF[2]=rtlines[0].v[2];
				tempdataF[3]=currentcolor[0];tempdataF[4]=currentcolor[1];tempdataF[5]=currentcolor[2];
				/*/////////*/
				instruction=tr("Distance pickpoint 2 or [Undo]:");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("U"))||!SecCmd.compare(tr("u"))){
					SendText(SecCmd);
					instruction=tr("Distance pickpoint 1:");emit instru(instruction);
					rtlines[0].find=0;SecCmd="BlankCommand";step--;
			return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){
					var[0]=currentdata.v[0]-rtlines[0].v[0];
					var[1]=currentdata.v[1]-rtlines[0].v[1];
					var[2]=currentdata.v[2]-rtlines[0].v[2];
					
					
				}
				
				if(currentdata.format==1){
					var[0]=currentdata.v[0];
					var[1]=currentdata.v[1];
					var[2]=currentdata.v[2];
				}
				
				var[3]=sqrt(var[0]*var[0]+var[1]*var[1]+var[2]*var[2]);
				SendText(QString(tr("Distance= %1")).arg(var[3]));
				SendText(QString(tr("dx= %1, dy= %2, dz= %3")).arg(var[0]).arg(var[1]).arg(var[2]));
				
				
				CmdCancel();
			return;
			}
		break;
		

	
	
	
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
