#!/usr/local/bin/perl
###############################################################################################################################
# assp-monitor
# --------------
# can be used instead of a syslog-server to have a local or remote monitor of assp
# 1. configure the syslog option in assp
# 2. copy this script to your monitor system, if you are using this script on the local assp system just copy
#    this script in to the assp directory
# 3. be sure there is no syslog daemon running on the system - or use an other port (1514 instead of 514)
# 4. run the script - if started on the local assp system the script will try to find the SysLogPort
#    in assp.cfg
#    if started on a remote system, define the listenport as first parameter - like
#    perl assp-monitor.pl 1514 or the default port 514 will be used
###############################################################################################################################
# this script is just simple - you may change it to your needs
###############################################################################################################################
##############################################
# (c) Thomas Eckardt 2009 under the terms of the GPL
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation;

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
##############################################

 use strict;
 use IO::Socket;

 my $msg;
 my $port;  # default = 514
 my $sl;
 my $base;
 my $cfg;
 my $sysLog;
 my $sysLogIp;
 
 if ($ARGV[0] =~ /^\d+$/) {
     $port = $ARGV[0];
 } elsif ($ARGV[0]) {
     $base = $ARGV[0] if $ARGV[0];
 }
 
 $cfg = 'assp.cfg';
 $cfg = "$base/assp.cfg" if $base;

 if (!$port && open F, "<$cfg") {
     while (<F>) {
         s/\r?\n//g;
         if (/sysLogPort:=/) {
             ($sl,$port) = split(/:=/,$_);
         } elsif (/sysLog:=/) {
             ($sl,$sysLog) = split(/:=/,$_);
         } elsif (/sysLogIp:=/) {
             ($sl,$sysLogIp) = split(/:=/,$_);
         }
     }
     close F;
 }

 $port = 514 unless $port;
 
# try opening an UDP socket
 my $socket = IO::Socket::INET->new(
   Proto => "udp",
   LocalPort => $port,
   ReuseAddr => 1,
 )
 or die "Problem: $!";                 # if we are dieing here - maybe a syslog daemon is using our port!

 $sysLog = $sysLog == 1 ? 'enabled' : 'disabled ??? (should be enabled)';

 print "\nassp-monitor.pl is listening for UDP-connections on port $port\n\n";
 print "found syslog configuration in $cfg:\nIP     : $sysLogIp\nPort   : $port\nsysLog : $sysLog\n\n" if $sl;
# listen on udp-port - format the message to looks like assp log output
# print the message to screen - do this until process is killed or socket is died
 while ($socket->recv($msg, 1024)) {
   chomp($msg);
   my $m=localtime();
   $m=~s/^... (...) +(\d+) (\S+) ..(..)/$1-$2-$4 $3/;
   $msg =~ s/^\<.*\]\: //;
   print "$m $msg\n";
 }
