<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

    
	/**
	 * implements moderation of comments
	 */
	class PluginValidateTrackback extends PluginBase
	{
	    var $pluginEnabled;
	    
		function PluginValidateTrackback( $source = "" )
		{
			$this->PluginBase( $source );
			
			$this->id = "validatetrackback";
			$this->desc = "Provides validation of trackbacks.";
			$this->author = "Paul Westbrook";
			$this->locales = Array( "en_UK", "zh_TW", "zh_CN", "es_ES" );
            $this->version = "20070417";
			
			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
		}

        function init(){
            lt_include( PLOG_CLASS_PATH."plugins/validatetrackback/class/security/validatetrackbackfilter.class.php" );
                // register the filter
            $this->registerFilter( "ValidateTrackbackFilter" );       
        }
        
        
		/**
		 * registers all the filters and actions that we're going to use
		 */
		function initAdmin()
		{			
            lt_include( PLOG_CLASS_PATH."plugins/validatetrackback/class/security/validatetrackbackfilter.class.php" );
            $this->registerFilter( "ValidateTrackbackFilter" );
			
			// register an action that will allow users to see which comments have not been
			// accepted yet
			$this->registerAdminAction( "validatetrackbackPluginSettings", "AdminValidateTrackbackPluginSettingsAction" );
			$this->registerAdminAction( "validatetrackbackPluginUpdateSettings", "AdminValidateTrackbackPluginUpdateSettingsAction" );
			
			// add a menu entry
			$menu =& Menu::getMenu();
            if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))                     
                $this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "", true, false );
            $this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "validatetrackbackPluginSettings", "admin.php?op=validatetrackbackPluginSettings", "", true, false );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_validatetrackback_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }		
	    
	    function getPluginConfigurationKeys()
		{			
			return( Array(
				Array( "name" => "plugin_validatetrackback_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_validatetrackback_trackback_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_validatetrackback_dns_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_validatetrackback_linkchecking_enabled", "type" => "boolean" ),
			));
		}

	}  
?>