<?php
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );


	/**
	 * implements notification of
	 */
	class PluginTwitter extends PluginBase
	{
		var $pluginEnabled;
		var $twitterUsername;
		var $twitterPassword;
		var $cacheFolder;

		function PluginTwitter( $source = "" )
		{
			$this->PluginBase( $source );

			$this->id = "twitter";
			$this->desc = "Posts to twitter when a new article is added.";
			$this->author = "Paul Westbrook (Twitter php library provided by <a href=\"http://blog.slawcup.com/5\">David Billingham</a>)";
			$this->locales = Array( "en_UK" );
			$this->version = "20070608";

			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
		}

		function init()
		{
			// register the events we want
			$this->registerNotification( EVENT_POST_POST_ADD );
		}

		function initAdmin()
		{
			$this->init();

			// register an action that will allow users to see which comments have not been
			// accepted yet
			$this->registerAdminAction( "twitterPluginSettings", "PluginTwitterConfigAction" );
			$this->registerAdminAction( "twitterPluginUpdateSettings", "PluginTwitterUpdateConfigAction" );

			// add a menu entry
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageIntegrationPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageIntegrationPlugins", "", "", true, false );			
			$this->addMenuEntry( "/menu/controlCenter/manageIntegrationPlugins", "twitter", "admin.php?op=twitterPluginSettings", "", true, false );
		}

		function register()
		{
			$config =& Config::getConfig();

			$blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_twitter_enabled" );
			$this->twitterUsername = $blogSettings->getValue( "plugin_twitter_username" );
			$this->twitterPassword = $blogSettings->getValue( "plugin_twitter_password" );
		}

		function isEnabled()
		{
			return $this->pluginEnabled;
		}

		/**
		 * process the events that we have registered
		 *
		 * @see PluginBase::process
		 * @see PluginManager
		 */
		function process( $eventType, $params )
		{
			$validEvent = false;

			if ( $eventType != EVENT_POST_POST_ADD )
			{
				return true;
			}

			// Load all of the settings for this blog
			$this->register();

			// do nothing if the plugin is not enabled!
			if( !$this->isEnabled() )
			{
				// error_log( "plugin not enabled" );
				return true;
			}

            $post = $params["article"];
                        
			$this->PostTweet( $post );

			return true;
		}

        /**
         * post a tweet to twitter with the url of this post
         */

		function PostTweet( $post )
		{
			
			$url = $this->blogInfo->getBlogRequestGenerator();
		
		    // Get the url from the article
		    $postUrl = $url->postPermalink( $post );
		    
		    lt_include( PLOG_CLASS_PATH."plugins/twitter/class/twitter/twitter.class.php" );	
		    
		    $t = new twitter();
            $t->username = $this->twitterUsername;
            $t->password = $this->twitterPassword;
            
            $res = $t->update($postUrl);
            /*
            if($res===false){
               error_log( "ERROR posting tweet" . $t->responseInfo);
            }else{
                error_log( "SUCCESS Status Posted" );
            }
            */
            
		}

		function getPluginConfigurationKeys()
		{
            lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );

			return (Array(
						Array("name" => "plugin_twitter_enabled",
							  "type" => "boolean"),
				        Array( "name" => "plugin_twitter_username", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
				        Array( "name" => "plugin_twitter_password", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
						)
				   );
		}

	}
?>