<?php

    lt_include(PLOG_CLASS_PATH . "class/plugin/pluginbase.class.php");
    lt_include(PLOG_CLASS_PATH . "class/plugin/pluginmanager.class.php");
    
    /*
    * Plugin that offers features to return links to the next and previous articles
    * within the current category
    */
    class PluginTidyOutput extends PluginBase
    {
        /**
        * Constructor
        */
        function PluginTidyOutput( $source )
        {
            $this->author = "Carles Balaguer";
			$this->desc = "This plugin clean and repair HTML markup using Tidy HTML extension for PHP. Information about the Tidy extension is available at <a href=\"http://www.php.net/tidy\">http://www.php.net/tidy</a> and information about the Tidy configuration settings can be found at <a href=\"http://tidy.sourceforge.net/docs/quickref.html\">http://tidy.sourceforge.net/docs/quickref.html</a>";
            
            $this->PluginBase( $source );
            $this->id = "tidyoutput";
            $this->version = "20070323";

            $this->init();

            lt_include(PLOG_CLASS_PATH . "plugins/tidyoutput/class/tidy/tidy.class.php");
            
            if (Tidy::isInstalled())
            {
                $this->registerNotification(EVENT_PROCESS_BLOG_TEMPLATE_OUTPUT);
            }
            else
            {
				$this->desc .= "<br /><span style=\"color: #ff0000;\">This plugin requires the PHP Tidy extension. Please install and enable this extension. See the links above for additional documentation.</span>";
            }
        }

        /**
        * Add function info here
        */
        function init()
        {
            if( $this->getSource() == "admin" ) {
                $this->registerAdminAction("tidyoutput", "PluginTidyOutputConfigAction");
                $this->registerAdminAction("tidyoutputUpdateConfig", "PluginTidyOutputUpdateConfigAction");

                lt_include(PLOG_CLASS_PATH . "class/template/menu/menu.class.php");
                $menu = &Menu::getMenu();
            
                if (!$menu->entryExists( "/menu/adminSettings/manageOutputPlugins"))
                {
                    $this->addMenuEntry("/menu/adminSettings", "manageOutputPlugins", "", "", true, false);
                }

                if (!$menu->entryExists( "/menu/adminSettings/manageOutputPlugins/TidyOutput"))
                {
                    $this->addMenuEntry("/menu/adminSettings/manageOutputPlugins", "TidyOutput", "?op=tidyoutput", "");
                }
            }
        }

        /**
        * Add function info here
        */
        function process($eventType, $params)
        {
            if ($eventType == EVENT_PROCESS_BLOG_TEMPLATE_OUTPUT)
            {
                // If output is a RSS output or come from authimageshow call do not tidyfy
                if ($params["from"] != "rssview" &&
                    $params["from"] != "pluginrecentcommentsrssview" &&
                    $params["template"] != "authimageshow")
                {
                    $params["content"] = $this->tidyfy($params["content"]);
                }
            }
        
            return true;
        }
    
        /**
        * Add function info here
        */
        function tidyfy($output)
        {
            $config  = &Config::getConfig();
            $enabled = $config->getValue("plugin_tidyoutput_enabled");
            $report  = $config->getValue("plugin_tidyoutput_report");
            $silent  = $config->getValue("plugin_tidyoutput_silent_mode");
            $errors  = $config->getValue("plugin_tidyoutput_errors");
            
            if (!$enabled)
            {
                return $output;
            }

            lt_include(PLOG_CLASS_PATH . "plugins/tidyoutput/class/tidy/tidy.class.php");
            lt_include(PLOG_CLASS_PATH . "plugins/tidyoutput/config/options.properties.php");
            
            $tidy = new Tidy();
            $tidy->setOptions($options);
            $tidy->parse($output);
            $tidy->cleanRepair();

            $result = $tidy->getOutput();
            
            if ($report)
            {
                $size1  = strlen($output);
                $size2  = strlen($result);
                $saving = round((1 - ($size2 / $size1)) * 100);

                $report = "Tidy report: " . $tidy->getErrorsCount() . " error(s), " . $tidy->getWarningsCount() . " warning(s)";

                if ($errors)
                {
                    $report .= PHP_EOL . $tidy->getErrors();
                }

                $report .= PHP_EOL . "Output: " . $this->normalizeSize($size1, 2) . ", Output through Tidy: " . $this->normalizeSize($size2, 2) . ", Saving: " . $saving . "%";
                
                if ($silent)
                {
                    $report = "<!--" . PHP_EOL . $report . PHP_EOL . "-->";
                }
                else
                {
                    $report = "<pre>" . PHP_EOL . htmlentities($report) . PHP_EOL . "</pre>";
                }

                $result .= $report;
            }

            return $result;
        }

        /**
        * Add function info here
        */
        function normalizeSize($size, $decimals = null)
        {
            $sizes = array("B", "KB", "MB", "GB", "TB", "PB", "EB");
            $ext   = $sizes[0];
            $count = count($sizes);

            for ($i = 1; ($i < $count) && ($size >= 1024); $i++)
            {
                $size = $size / 1024;
                $ext  = $sizes[$i];
            }

            return round($size, $decimals). " " . $ext;
        }
    }
?>