<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/templatenamevalidator.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsiteedittemplatefileview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsiteeditsubfoldertemplatefileview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsitetemplatesetslistview.class.php" );	

	/**
	 * shows a form with the current configuration
	 */
	class PluginSiteEditTemplateFileAction extends AdminAction
	{
        var $_templateId;
        var $_subFolderId;      
        var $_fileId;
        var $_backupId;
        		
		function PluginSiteEditTemplateFileAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
			// special validator
			$val = new StringValidator();
			$val->addRule( new RegExpRule( "[a-zA-Z0-9]*" ));
			
			$this->registerFieldValidator( "templateId", $val );
			$this->registerFieldValidator( "subFolderId", $val, true );
			$this->registerFieldValidator( "fileId", new TemplateNameValidator());
            $view = new PluginSiteTemplateSetsListView( $this->_blogInfo );
			$view->setErrorMessage( "error_loading_template_file" );
			$this->setValidationErrorView( $view );
			
			$this->requireAdminPermission( "edit_global_templates" );			
		}
		
		function perform()
		{
			// fetch and sanitize parameters
            $this->_templateId = $this->_request->getValue( "templateId" );
			$this->_templateId = str_replace( "/", "", $this->_templateId );
			$this->_templateId = str_replace( "..", "", $this->_templateId );
			
			// sanitize parameter subFolderId
            $this->_subFolderId = $this->_request->getValue( "subFolderId" );			
			$this->_subFolderId = str_replace( "/", "", $this->_subFolderId );
			$this->_subFolderId = str_replace( "..", "", $this->_subFolderId );

			// fetch and sanitize the "fileId" parameter
            $this->_fileId = $this->_request->getValue( "fileId" );
			$this->_fileId = str_replace( "/", "", $this->_fileId );
			$this->_fileId = str_replace( "..", "", $this->_fileId );			
			
            $this->_backupId = $this->_request->getValue( "backupId" );
            
            if ( empty($this->_subFolderId) ) {
                $this->_view = new PluginSiteEditTemplateFileView( $this->_blogInfo, $this->_templateId, $this->_fileId, $this->_backupId );
            } else {
                $this->_view = new PluginSiteEditSubFolderTemplateFileView( $this->_blogInfo, $this->_templateId, $this->_subFolderId, $this->_fileId, $this->_backupId );
            }
            
			$this->setCommonData();
			
			return true;
		}
	}
?>