<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    lt_include( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );
    lt_include( PLOG_CLASS_PATH."class/net/rawrequestgenerator.class.php" );	
	
	define( "POST_STATUS_EXTERNAL_SUBMISSION", 200 );
	
	/**
	 * allows users to submit posts to the blog, and keeps them in a separate queue
	 */
	class PluginSubmissions extends PluginBase
	{
	
		function PluginSubmissions()
		{
			$this->PluginBase();
			
			$this->id = "submissions";
			$this->desc = "Allows visitors to submit stories to the blog.";
			$this->author = "The LifeType Project";
			$this->version = "20070423";
			
			$this->init();
		}
		
		/**
		 * registers all the filters and actions that we're going to use
		 */
		function init()
		{			
		    // action to show the form to add a new story
		    $this->registerBlogAction( "submissionForm", "ShowSubmissionFormAction" );
		    $this->registerBlogAction( "submitStory", "AddSubmissionAction" );
			$this->registerAdminAction( "submissionsPluginSettings", "AdminSubmissionsPluginSettingsAction" );
			$this->registerAdminAction( "pluginSubmissionsUpdateSettings", "AdminSubmissionsPluginUpdateSettingsAction" );
			
			// add a couple of menu entries
			$this->addMenuEntry( "/menu/Manage/managePosts", "submissionsPluginSettings", "admin.php?op=submissionsPluginSettings", "", true, false );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_submissions_enabled" );
		    $this->htmlareaEnabled = $blogSettings->getValue( "plugin_submissions_htmlarea_enabled" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

	    function isHtmlareaEnabled()
	    {
	        return $this->htmlareaEnabled;
	    }

        function pluginTemplatePage()
        {
 			$rg = new RawRequestGenerator($this->blogInfo);
            
        	$rg->addParameter( "op", "submissionForm" );
            $rg->addParameter( "blogId", $this->blogInfo->getId());

            $templatePage = $rg->getIndexUrl().$rg->getRequest();

            return $templatePage;
        }	    		
	}  
?>