<?php
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class PluginSociableConfigView extends AdminPluginTemplatedView
	{
        var $_pm;



		function PluginSociableConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "sociable", "sociable" );
			
			$this->_pm =& PluginManager::getPluginManager();
			$this->_pm->setBlogInfo( $this->_blogInfo );

		}
		
		function render()
		{
			// load some configuration settings
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_sociable_enabled" );
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );		
			
			$plugins = $this->_pm->getPlugins();

            // now $plugins is an array where the key is the plugin id
            // and the value is an instance of the PluginXXX class
            $plugin = $plugins["sociable"];

			$this->setValue( sociable, $plugin );
			
			parent::render();
		}
	}
?>