<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/smileys/class/view/pluginsmileysconfigview.class.php" );		
		
	/**
	 * updates the plugin configuration
	 */
	class PluginSmileysUpdateConfigAction extends AdminAction
	{
	
		var $_pluginEnabled;
		var $_smileySet;
		
		function PluginSmileysUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
			$this->requirePermission( "manage_plugins" );			
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
            $this->_smileySet = $this->_request->getValue( "setId" );
            if( $this->_smileySet == "" ) $this->_smileySet = DEFAULT_SMILEY_SET;
			
			return true;
		}
		        
		function perform()
		{
            // and check which smiley set we should be using, or if none, then the default one
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_smileys_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_smileys_iconset", $this->_smileySet );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginSmileysConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginSmileysConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("smileys_settings_saved_ok"));
			$this->setCommonData();

			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
	}
?>