<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Plugin that offers features to return a recent article trackbacks from the current blog
     */
    class PluginRecentTrackbacks extends PluginBase
    {
        var $pluginEnabled;
        var $maxTrackbacks;
        
        function PluginRecentTrackbacks($source = "")
        {
            $this->PluginBase($source);
            $this->id = "recenttrackbacks";
            $this->version = "20070407";

            $this->author = "Mark Wu";
            $this->desc = "This plugin offers the most recently posted article trackbacks.";
            $this->locales = Array( "en_UK" , "zh_TW" , "zh_CN", "es_ES" );

			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
        }

		function initAdmin(){
            $this->registerAdminAction( "recenttrackbacks", "PluginRecentTrackbacksConfigAction" );
			$this->registerAdminAction( "updateRecentTrackbacksConfig",
                                        "PluginRecentTrackbacksUpdateConfigAction" );
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageRecentPlugins" ))
				$this->addMenuEntry( "/menu/controlCenter", "manageRecentPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageRecentPlugins", "RecentTrackbacks", "?op=recenttrackbacks", "" );            
		}

        function init(){
            $this->registerBlogAction( "recenttrackbacksrss", "PluginRecentTrackbacksRssAction" );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_recenttrackbacks_enabled" );
	        $this->maxTrackbacks = $blogSettings->getValue( "plugin_recenttrackbacks_maxtrackbacks", DEFAULT_ITEMS_PER_PAGE );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

        /**
         * Returns the recent trackbacks object of current blog
         */
        function getRecentTrackbacks()
        {
            lt_include( PLOG_CLASS_PATH."class/dao/trackbacks.class.php" );

            $blogId = $this->blogInfo->getId();
            $articleTrackbacks = new Trackbacks();
            $trackbacks = $articleTrackbacks->getBlogTrackbacks( $blogId, COMMENT_STATUS_NONSPAM, "", 1, $this->maxTrackbacks );

            return( $trackbacks );
        }

        /**
         * Returns an article given an id
         * This is needed here because we need to get various
         * articles, not just the most recent, etc. that are generally
         * available to the templates.
         */
        function getArticle( $artId )
        {
			lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );				
            $articles = new Articles();
            return $articles->getArticle($artId);
        }

        function getRssFeedUrl(){
            lt_include( PLOG_CLASS_PATH."class/net/rawrequestgenerator.class.php" );

            $rg = new RawRequestGenerator($this->blogInfo);
            $rg->addParameter( "op", "recenttrackbacksrss" );
            $rg->addParameter( "blogId", $this->blogInfo->getId());

            $feedUrl = $rg->getIndexUrl().$rg->getRequest();
            return $feedUrl;
        }

        function getPluginConfigurationKeys(){
			lt_include(PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php");
            return (Array(
                        Array("name" => "plugin_recenttrackbacks_enabled",
                              "type" => "boolean"),
                        Array("name" => "plugin_recenttrackbacks_maxtrackbacks",
                              "validator" => new IntegerValidator(),
                              "type" => "integer", "allowEmpty" => true ),
                        )
                   );
        }
        
    }
?>