<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/trackbacks.class.php" );

	class PluginRecentTrackbacksRssView extends PluginTemplatedView
	{
		function PluginRecentTrackbacksRssView($blogInfo){
			$this->PluginTemplatedView( $blogInfo, "recenttrackbacks", "rss20" );
		}
		
		function render(){
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_recenttrackbacks_enabled" );
			$maxTrackbacks = $blogSettings->getValue( "plugin_recenttrackbacks_maxtrackbacks" );
			if($maxTrackbacks == "")
                $maxTrackbacks = DEFAULT_ITEMS_PER_PAGE;

            $blogTrackbacks = array();
            $articleTrackbacks = new Trackbacks();
            $blogTrackbacks = $articleTrackbacks->getBlogTrackbacks( $this->_blogInfo->getId(), 
                                                              COMMENT_STATUS_NONSPAM,
                                                              "",
                                                              1,
                                                              $maxTrackbacks );
                 
			$this->setValue("trackbacks", $blogTrackbacks);
            $this->setContentType( 'text/xml' );
			parent::render();
		}

    }
?>