<?php

    lt_include( PLOG_CLASS_PATH."class/action/action.class.php" );
    lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );
    lt_include( MOBILE_PLOG_CLASS_PATH."class/net/mobilerequestgenerator.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );

    class MobileAction extends Action
    {
    
        var $_blogInfo;
        var $_locale;
        var $_tInfo;
    
        function MobileAction( $actionInfo, $httpRequest )
        {
            $this->Action( $actionInfo, $httpRequest );
            
            $this->_blogInfo = $this->_getBlogInfo();
            $this->_locale =& $this->_blogInfo->getLocale();
            
            // detect the terminal that made the request...
            $ti = new TerminalIdentifier();
            $this->_tInfo = $ti->identify( $_SERVER );
            
            // ...and quit the whole thing if there is no 'default' terminal
            if( !$this->_tInfo ) {
                die( "No terminal matched the request! Make sure that at least there is
                      one matching terminal definition." );
            }            
        }
        
        /**
         * @private
         */
        function _getBlogInfo()
        {
			lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
            $blogId = $this->_request->getValue( "blogId" );
            $val = new IntegerValidator();
            if( !$val->validate( $blogId )) {
                $config =& Config::getConfig();
                $blogId = $config->getValue( "default_blog_id" );
            }
            
            // try to load the blog
            $blogs = new Blogs();
            $blogInfo = $blogs->getBlogInfo( $blogId );
            
            if( !$blogInfo ) {
                die( "ERROR: The blog does not exist" );
            }
            
            if( $blogInfo->getStatus() != BLOG_STATUS_ACTIVE ) {
                die( "ERROR: The blog does not exist" );            
            }
            
            return( $blogInfo );
        }
        
        function setCommonData()
        {            
            $this->_view->setValue( "blog", $this->_blogInfo );
            $this->_view->setValue( "murl", new MobileRequestGenerator( $this->_blogInfo ));
            $this->_view->setValue( "terminall", $this->_tInfo );
        }
    }
?>