<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    lt_include( PLOG_CLASS_PATH."class/net/requestgenerator.class.php" );	
	
	/**
	 * our custom status for posts
	 */
	define( "POST_STATUS_KARMA_MODERATED_DOWN", 100 );
	
	/**
	 * implements host blocking features
	 */
	class PluginKarma extends PluginBase
	{
	    var $pluginEnabled;
	
		function PluginKarma( $source )
		{
			$this->PluginBase( $source );
			
			$this->id = "karma";
			$this->desc = "Implements karma rating for posts";
			$this->author = "The LifeType Team";
			$this->locales = Array();
			$this->version = "20070315";
			
			$this->init();
		}
		
		/**
		 * registers all the filters and actions that we're going to use
		 */
		function init()
		{
			if( $this->getSource() == "index" ) {
				$this->registerBlogAction( "karmaRate", "KarmaRateAction" );
				$this->registerBlogAction( "viewModeratedDown", "ViewModeratedDownAction" );	
			}
			else {
				$this->registerBlogAction( "viewModeratedDownArticle", "ViewModeratedDownArticleAction" );
				$this->registerAdminAction( "karmaPluginSettings", "AdminKarmaPluginSettingsAction" );
				$this->registerAdminAction( "pluginKarmaUpdateSettings", "AdminKarmaPluginUpdateSettingsAction" );			

				// add a menu entry
				$this->addMenuEntry( "/menu/Manage/managePosts", "karmaPluginSettings", "admin.php?op=karmaPluginSettings", "", true, false );				
			}
		}
		
		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_karma_enabled" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

        function pluginTemplatePage()
        {
 			$rg = $this->blogInfo->getBlogRequestGenerator();
            $templatePage = $rg->getIndexUrl()."?op=viewModeratedDown&amp;blogId=".$this->blogInfo->getId();

            return $templatePage;
        }	    
		
		/**
		 * returns the correct url to the action that scores the points
		 *
		 * @param post An Article object
		 * @return A complete address
		 */
		function getPositiveUrl( $post )
		{
			$url =& $this->blogInfo->getBlogRequestGenerator();
			$karmaUrl = $url->getBaseUrl()."/index.php?op=karmaRate&amp;mode=1&amp;articleId=".$post->getId()."&amp;blogId=".$post->getBlog();
			
			return $karmaUrl;
		}
		
		/**
		 * returns the correct url to the action that scores the points
		 *
		 * @param post An Article object
		 * @return A complete address
		 */
		function getNegativeUrl( $post )
		{
			$url =& $this->blogInfo->getBlogRequestGenerator();
			$karmaUrl = $url->getBaseUrl()."/index.php?op=karmaRate&amp;mode=2&amp;articleId=".$post->getId()."&amp;blogId=".$post->getBlog();
			
			return $karmaUrl;			
		}
		
		/**
		 * returns the correct url to browse a moderated down article
		 *
		 * @param post
		 * @return A url
		 */
		function moderatedDownLink( $post )
		{
			$url =& $this->blogInfo->getBlogRequestGenerator();
			$modDownLink = $url->getIndexUrl()."?op=viewModeratedDownArticle&amp;articleId=".$post->getId()."&amp;blogId=".$post->getBlog();
			
			return $modDownLink;
		}
		
		/**
		 * returns the link to the page with the list of moderated down articles
		 *
		 * @param blog
		 * @return The correct link to the list
		 */
		function moderatedDownListLink( $blog )
		{
			$url =& $this->blogInfo->getBlogRequestGenerator();
			$listLink = $url->getIndexUrl()."?op=viewModeratedDown&amp;blogId=".$blog->getId();
			
			return $listLink;
		}
	}  
?>