<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/karma/class/view/adminkarmapluginsettingsview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/karma/class/karma/karmalib.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfields.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfield.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );

    class AdminKarmaPluginUpdateSettingsAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_disablePosts;
		var $_negativeThreshold;
		var $_trackVoters;
		var $_scoringCoefficient;

    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminKarmaPluginUpdateSettingsAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );

			$this->requirePermission( "manage_plugins" );
        }
		
		function validate()
		{
			$this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
			
			if( $this->_pluginEnabled == "" )
				$this->_pluginEnabled = false;
			else
				$this->_pluginEnabled = true;
				
			// get the parameters from the request
			$this->_disablePosts  = $this->_request->getValue( "disableNegative" );
			$this->_negativeThreshold = $this->_request->getValue( "negativeThreshold" );
			$val2 = new IntegerValidator();
			if( !$val2->validate( $this->_negativeThreshold ) || $this->_negativeThreshold < 0 )
				$this->_negativeThreshold  = PLUGIN_KARMA_DEFAULT_NEGATIVE_THRESHOLD;		

			$this->_trackVoters = $this->_request->getValue( "trackVoters" );
			
			// check the scoring coefficient
			$this->_scoringCoefficient = $this->_request->getValue( "scoring" );
			$val = new IntegerValidator();
			if( !$val->validate( $this->_scoringCoefficient ) || $this->_scoringCoefficient < 0 )
				$this->_scoringCoefficient  = PLUGIN_KARMA_DEFAULT_COEFFICIENT;
			
			return true;
		}
		
		/**
		 * checks if the fields already exist and if not, creates them
		 *
		 * @private
		 */
		function _createFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			// check if the checkbox fields exists
			if( !array_key_exists( "positiveKarma", $blogFields )) {
				$customPositiveKarma = new CustomField( "positiveKarma", 
				                                           $this->_locale->tr("positiveKarma_help"),
														   CUSTOM_FIELD_TEXTBOX,
														   $this->_blogInfo->getId(),
														   false,
														   true );
				$customFields->addCustomField( $customPositiveKarma );			
			}
			else {
				// if it already exists, then don't remove it but set it to hidden
				$customPositiveKarma = $blogFields["positiveKarma"];
				$customPositiveKarma->setHidden( false );
				$customFields->updateCustomField( $customPositiveKarma );
			}
			
			// check if the field for the password exists
			if( !array_key_exists( "negativeKarma", $blogFields )) {
				$customNegativeKarma = new CustomField( "negativeKarma", 
				                                                $this->_locale->tr("negativeKarma_help"),
												      		    CUSTOM_FIELD_TEXTBOX,
														        $this->_blogInfo->getId(),
																false,
														        true );
				$customFields->addCustomField( $customNegativeKarma );
			}
			else {
				// if it already exists, then don't remove it but set it to hidden			
				$customNegativeKarma = $blogFields["negativeKarma"];
				$customNegativeKarma->setHidden( false );
				$customFields->updateCustomField( $customNegativeKarma );			
			}
			
			return true;
		}
		
		/**
		 * checks if the fields already exist and if so, disables them (sets them to be "hidden")
		 *
		 * @private
		 */
		function _updateFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			// check if the checkbox fields exists
			if( array_key_exists( "positiveKarma", $blogFields )) {
				$customPositiveKarma = $blogFields["positiveKarma"];
				$customPositiveKarma->setHidden( false );
				$customFields->updateCustomField( $customPositiveKarma );
			}
			
			// check if the field for the password exists
			if( array_key_exists( "negativeKarma", $blogFields )) {
				$customNegativeKarma = $blogFields["negativeKarma"];
				$customNegativeKarma->setHidden( false );
				$customFields->updateCustomField( $customNegativeKarma );			
			}
			
			return true;
		}		

        /**
         * Carries out the specified action
         */
        function perform()
        {
			// save the plugin settings to the db
			$blogSettings = $this->_blogInfo->getSettings();
			$blogSettings->setValue( "plugin_karma_enabled", $this->_pluginEnabled );
			$blogSettings->setValue( "plugin_karma_disable_negative_articles", $this->_disablePosts );
			$blogSettings->setValue( "plugin_karma_negative_threshold", $this->_negativeThreshold );
			$blogSettings->setValue( "plugin_karma_track_voters", $this->_trackVoters );
			$blogSettings->setValue( "plugin_karma_scoring_coefficient", $this->_scoringCoefficient );
			
			$this->_blogInfo->setSettings( $blogSettings );
			$blogs = new Blogs();
			
			// update the settings in the db, and make sure that everything went fine
			if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminKarmaPluginSettingsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false; 				
			}
			
			// check if the fields already exist and if not, create them
			if( $this->_pluginEnabled )
				$this->_createFields();
			else
				$this->_updateFields();
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new AdminKarmaPluginSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("karma_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;
        }
    }
?>