<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
	* inserts Iconize code in tempalte header.
	*/
    class PluginIconize extends PluginBase
    {
        var $pluginEnabled;
		var $iconize;
        
        function PluginIconize($source = "")
        {
			$this->PluginBase($source);
			
            $this->id = "iconize";
            $this->author = "poolie";
            $this->desc = "This Plugin inserts the Iconize CSS in the Template. (Iconize Version 0.3)";
            $this->version = "20070524";
            
            $this->locales = Array( "en_UK" , "de_DE" );
 
			if( $source == "admin" ) {
				$this->initAdmin();
		    }
			else {
				$this->init();
			}
        }

        function init() {}

		function initAdmin()
		{
			$this->registerAdminAction( "iconize", "PluginIconizeConfigAction" );
			$this->registerAdminAction( "updateiconize", "PluginIconizeUpdateConfigAction" );
			

			$menu =& Menu::getMenu();
            if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))                       
                $this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "");
			$this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "Iconize", "?op=iconize");
		}

		function register()
		{
		    $config =& Config::getConfig();
		    
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_iconize_enabled" );
	    }
        
		function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_iconize_enabled", "type" => "boolean" )
			));
		}
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

        /**
		* Returns Iconize javascript
		*/
        function getJavascriptCode()
        {
        lt_include( PLOG_CLASS_PATH."class/net/rawrequestgenerator.class.php" );
 	    $rg = new RawRequestGenerator($this->blogInfo);
 	    $cssUrl = $rg->getBaseUrl().'/plugins/iconize/templates/iconize.css';
 	    
		$jsCode = "";
		if( $this->isEnabled() ){
			$jsCode ="<!-- Iconize CSS Start -->\n"
                    ."<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"$cssUrl\" />\n"
                    ."<!-- Iconize CSS End -->\n";
		}
			return $jsCode;
        }
    }
?>
