<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class PluginHotlinkPreventionConfigView extends AdminPluginTemplatedView
	{

		function PluginHotlinkPreventionConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "hotlinkprevention", "hotlinkprevention" );
		}
		
		function render()
		{
			// load global configuration settings
			$config =& Config::getConfig();
			$globalPluginEnabled = $config->getValue( "plugin_globalhotlinkprevention_enabled" );
			$globalFileExtensions = $config->getValue( "plugin_globalhotlinkprevention_fileextensions" );
			$globalBlankRefererEnabled = $config->getValue( "plugin_globalhotlinkprevention_blankrefererenabled" );
			$globalAllowReferers = $config->getValue( "plugin_globalhotlinkprevention_allowreferers" );

			// load blog configuration settings
			$blogSettings = $this->_blogInfo->getSettings();
			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_enabled" ) ) {
				$pluginEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_enabled" );
			} else {
				$pluginEnabled = $globalPluginEnabled;
			}

			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_fileextensions" ) ) {
				$fileExtensions = $blogSettings->getValue( "plugin_hotlinkprevention_fileextensions" );
			} else {
				$fileExtensions = $globalFileExtensions;
			}

			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_blankrefererenabled" ) ) {
				$blankRefererEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_blankrefererenabled" );
			} else {
				$blankRefererEnabled = $globalBlankRefererEnabled;
			}			
			
			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_allowreferers" ) ) {
				$allowReferers = $blogSettings->getValue( "plugin_hotlinkprevention_allowreferers" );
			} else {
				$allowReferers = $globalAllowReferers;
			}
						
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "fileExtensions", $fileExtensions );
			$this->setValue( "blankRefererEnabled", $blankRefererEnabled );	
			$this->setValue( "allowReferers", $allowReferers );
			
			parent::render();
		}
	}
?>