<?php

	lt_include( PLOG_CLASS_PATH."class/dao/model.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/hostblock/class/dao/blockedhost.class.php" );
    
    define( "CACHE_BLOCKEDHOSTS_BLOG", "blockedhosts_blog" );
    define( "CACHE_BLOCKEDHOSTS", "blockedhosts" );

    /**
     * Class that implements the data access model to read information about the
     * hosts blocked in a site.
     * @see BlockedHost
     */
	class BlockedHosts extends Model 
	{

    	function BlockedHosts()
        {
        	$this->Model();
        	       
        	$this->table = $this->getPrefix()."host_blocking_rules";
        }

        function getBlockedHost( $id, $blogId = 0 )
        {
            $block = $this->get( "id", $id, CACHE_BLOCKEDHOSTS );
            if( $blogId > -1 )
                if( $block->getBlogId() != $blogId )
                    return false;
                    
            return( $block );
        }

        /**
         * Returns all the globally blacklisted hosts
         *
         * @param blockType Wether we'd like to fetch only those hosts that have
         * been blocked from posting comments (BLOCK_COMMENT_POSTING), from accesing the
         * site completely (BLOCK_ACCESS)
         * @return An array of BlockedHost objects with all the information necessary.
         */        
        function getGlobalBlacklist( $blockType = BLOCK_COMMENT_POSTING )
        {
            return( $this->getBlogBlacklist( 0, $blockType, false ));
        }

        /**
         * Returns all the 'whitelisted' hosts for the given blog
         *
         * @param blogId The blog identifier
         * @param blockType Wether we'd like to fetch only those hosts that have
         * been blocked from posting comments (BLOCK_COMMENT_POSTING), from accesing the
         * site completely (BLOCK_ACCESS)
         * @param includeGlobal 'true' if we'd like the function to return the hosts that
         * have been blocked by the given blog *AND* the global ones.
         * @return An array of BlockedHost objects with all the information necessary.
         */
        function getBlogBlacklist( $blogId, $blockType = BLOCK_COMMENT_POSTING, $includeGlobal = false )
        {        
            $data = Array();
            $blockedHosts = Array();
            
            $data = $this->getMany( "blog_id", $blogId, CACHE_BLOCKEDHOSTS_BLOG );
            if( $data ) {
                foreach( $data as $host ) {
                    if( $host->getType() == $blockType )
                        $blockedHosts[] = $host;
                }
            }
            
            if( $includeGlobal ) {
                /** merge this data with the globally blocked hosts **/
                $blockedHosts = array_merge( $blockedHosts, $this->getBlogBlacklist( "0", $blockType, false ));
            }
            
            return( $blockedHosts );
        }

        /**
         * Adds a host to our list of blocked hosts
         *
         * @param blockedHost A BlockedHost object
		 * @return True if successful or false otherwise
		 * @see BlockedHost
         */
        function add( $blockedHost )
        {
            if( $result = parent::add( $blockedHost )) {
                if( $blockedHost->isGlobal()) 
                    $id = 0;
                else
                    $id = $blockedHost->getBlogId();
                    
                // clean the cache with the right id
                $this->_cache->removeData( $id, CACHE_BLOCKEDHOSTS_BLOG );
            }
            
            return( $result );
        }

        /** 
         * removes a blocked host from the db
         *
         * @param id
         * @param blogId
         * @return True if successful or false otherwise
         */
        function remove( $id, $blogId = -1 )
        {
            $block = $this->getBlockedHost( $id, $blogId );
            if( $blogId > -1 )
                if( $block->getBlogId() != $blogId )
                    return false;
                    
            if(( $result = $this->delete( "id", $id ))) {
                $this->_cache->removeData( $block->getBlogId(), CACHE_BLOCKEDHOSTS_BLOG );
            }
            
            return $result;
        }

        /**
         * updates a blocked host
         *
         * @param blockedHost
         */
        function update( $blockedHost )
        {  
            if(( $result = parent::update( $blockedHost ))) {
                $this->_cache->removeData( $blockedHost->getBlogId(), CACHE_BLOCKEDHOSTS_BLOG );
                $this->_cache->removeData( $blockedHost->getId(), CACHE_BLOCKEDHOSTS );
            }
            
            return( $result );
        }

        /**
         * @private
         */
        function mapRow( $row )
        {
        	$blockedHost = new BlockedHost( $row["host"],
                                            $row["mask"],
                                            $row["reason"],
                                            $row["date"],
                                            $row["blog_id"],
                                            $row["block_type"],
                                            $row["list_type"],
                                            $row["id"] );

            return $blockedHost;
        }
    }
?>