<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/hiddeninput/class/view/pluginhiddeninputconfigview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );	
			
	/**
	 * updates the plugin configuration
	 */
	class PluginHiddenInputUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_hiddenFields;
		var $_emptyFields;
		
		function PluginHiddenInputUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );	
            $this->_hiddenFields = $this->_request->getValue( "hiddenFields" );
            $this->_hiddenFields = ereg_replace("[[:space:]]", "", $this->_hiddenFields);
            $val = new StringValidator();
            if( !$val->validate($this->_hiddenFields) ) {
                $this->_view = new PluginHiddenInputConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("hiddeninput_error_hiddenfields"));
                $this->setCommonData();

                return false;
            }

                // Check to make sure that all values in the empty fields input
                // box are also in the hidden fields
            $this->_emptyFields = $this->_request->getValue("emptyFields");
            $this->_emptyFields = ereg_replace("[[:space:]]", "", $this->_emptyFields);
            $emptyFieldsExploded = explode(",", $this->_emptyFields);

            foreach($emptyFieldsExploded as $emptyField){
                if($emptyField){
                    if(strpos($this->_hiddenFields, $emptyField) === FALSE){
                        $this->_view =
                            new PluginHiddenInputConfigView($this->_blogInfo);
                        $this->_view->setErrorMessage(
                            $this->_locale->tr("hiddeninput_error_emptyfields"));
                        $this->setCommonData();
                        return false;
                    }
                }
            }

            return true;
		}
		        
		function perform()
		{
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_hiddeninput_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_hiddeninput_hiddenfields", $this->_hiddenFields );
            $blogSettings->setValue( "plugin_hiddeninput_emptyfields", $this->_emptyFields );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginHiddenInputConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginHiddenInputConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("hiddeninput_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
	}
?>