<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/gravatar/class/avatars/avatars.class.php" );	

	/**
	 * implements the main view of the feed reader plugin
	 */
	class PluginGravatarConfigView extends AdminPluginTemplatedView
	{

		function PluginGravatarConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "gravatar", "gravatar" );
		}
		
		function render()
		{
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_gravatar_enabled" );
			$rating = $blogSettings->getValue( "plugin_gravatar_rating" );
			if ($rating == "") $rating = "G";
			$default = $blogSettings->getValue( "plugin_gravatar_default" );
			if ($default == "") $default = "default.jpg";
			$size = $blogSettings->getValue( "plugin_gravatar_size" );
			if ($size == "") $size = 40;	
			
			$avatars = Avatars::scanAvatarImages();	
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "rating", $rating );
			$this->setValue( "default", $default );
			$this->setValue( "avatars", $avatars );
			$this->setValue( "size", $size );
			
			parent::render();
		}
	}
?>