<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
	* offers features to inset google analytics javascript codes in tempalte header.
	*/
    class PluginGoogleAnalytics extends PluginBase
    {
        var $pluginEnabled;
		var $uacct;
        
        function PluginGoogleAnalytics( $source = "" )
        {
			$this->PluginBase($source);
			
            $this->id = "googleanalytics";
            $this->author = "lss";
            $this->desc = "This plugin offers features to inset google analytics javascript codes in tempalte header";
            $this->version = "20070302";
  
            $this->locales = Array( "en_UK" , "zh_TW" , "zh_CN", "es_ES", "fr_FR" );
            
			if( $source == "admin" )
				$this->initAdmin();
        }

		function initAdmin()
		{
			$this->registerAdminAction( "googleanalytics", "PluginGoogleAnalyticsConfigAction" );
			$this->registerAdminAction( "updategoogleanalytics", "PluginGoogleAnalyticsUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
            $this->addMenuEntry( "/menu/controlCenter/manageSettings", "GoogleAnalytics", "?op=googleanalytics");
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_googleanalytics_enabled" );
	        $this->uacct = $blogSettings->getValue( "plugin_googleanalytics_uacct" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

        /**
		* Returns google analytics javascript
		*/
        function getJavascriptCode(){
            $jsCode = "";
            if( $this->isEnabled() ){
                $jsCode ="<script "
                    ."src=\"http://www.google-analytics.com/urchin.js\" "
                    ."type=\"text/javascript\">\n"
					."</script>\n"
					."<script type=\"text/javascript\">\n"
					."_uacct = \"".$this->uacct."\";\n"
					."urchinTracker();\n"
					."</script>\n";
            }
			return $jsCode;
        }
    }
?>
