<?php
	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/googleanalytics/class/view/plugingoogleanalyticsconfigview.class.php" );	
		
	/**
	 * updates the plugin configuration
	 */
	class PluginGoogleAnalyticsUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_uacct;
		
		function PluginStickyPostsUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $errorMessages = array();
			$this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
            
			$this->_uacct = $this->_request->getValue( "uacct" );
			if( $this->_pluginEnabled && empty($this->_uacct) ) {
                $errorMessages[] = "googleanalytics_error_uacct";
				$isError = true;
			}
			
			if( count($errorMessages) > 0 ) {
                $this->_view = new PluginGoogleAnalyticsConfigView( $this->_blogInfo );
				$allerror='';
				foreach( $errorMessages as $error ){
					$allerror .= $this->_locale->tr($error).'<br />';
				}
		$this->_view->setErrorMessage( $this->_locale->tr($allerror));
                $this->setCommonData();
                return false;
            }        	                
			
			return true;
		}
		        
		function perform()
		{
            // // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_googleanalytics_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_googleanalytics_uacct", $this->_uacct );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginStickyPostsConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();

			$this->_view = new PluginGoogleAnalyticsConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("googleanalytics_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());				
            
            return true;		
		}
	}
?>
