<?php

lt_include(PLOG_CLASS_PATH.'class/plugin/pluginbase.class.php');

class PluginGoogleAdsense extends PluginBase
{
    var $pluginEnabled;
    var $client;
    var $contentEnabled;
    var $contentWidth;
    var $contentHeight;
    var $contentFormat;
    var $contentType;
    var $contentChannel;
    var $suggestionEnabled;
    var $suggestionWidth;
    var $suggestionHeight;
    var $suggestionFormat;
    var $suggestionChoice;
    var $suggestionChannel;
    var $searchEnabled;

    function PluginGoogleAdsense($source = "")
    {
        $this->PluginBase($source);
        $this->id = 'googleadsense';
        $this->author = 'twu2';
        $this->desc = "This plugin offers features to support google adsense.";
        $this->version = '20070321';
        $this->locales = array('en_UK', 'zh_TW');
	if ($source == "admin")
            $this->initAdmin();
    }

    function initAdmin()
    {
        $this->registerAdminAction('googleadsense', 'PluginGoogleAdsenseConfigAction');
        $this->registerAdminAction('updategoogleadsense', 'PluginGoogleAdsenseUpdateConfigAction');
        $menu =& Menu::getMenu();
        $this->addMenuEntry('/menu/controlCenter/manageSettings', 'GoogleAdsense', '?op=googleadsense');
    }

    function register()
	{
        $blogSettings = $this->blogInfo->getSettings();
        $this->pluginEnabled = $blogSettings->getValue('plugin_googleadsense_enabled');

        $this->client = $blogSettings->getValue('plugin_googleadsense_client');

        $this->contentEnabled = $blogSettings->getValue('plugin_googleadsense_content_enabled');
        $this->contentWidth = $blogSettings->getValue('plugin_googleadsense_content_width');
        $this->contentHeight = $blogSettings->getValue('plugin_googleadsense_content_height');
        $this->contentFormat = $blogSettings->getValue('plugin_googleadsense_content_format');
        $this->contentType = $blogSettings->getValue('plugin_googleadsense_content_type');
        $this->contentChannel = $blogSettings->getValue('plugin_googleadsense_content_channel');

        $this->suggestionEnabled = $blogSettings->getValue('plugin_googleadsense_suggestion_enabled');
        $this->suggestionWidth = $blogSettings->getValue('plugin_googleadsense_suggestion_width');
        $this->suggestionHeight = $blogSettings->getValue('plugin_googleadsense_suggestion_height');
        $this->suggestionFormat = $blogSettings->getValue('plugin_googleadsense_suggestion_format');
        $this->suggestionChoice = $blogSettings->getValue('plugin_googleadsense_suggestion_choice');
        $this->suggestionChannel = $blogSettings->getValue('plugin_googleadsense_suggestion_channel');

        $this->searchEnabled = $blogSettings->getValue('plugin_googleadsense_search_enabled');
    }

    function isEnabled()
    {
        return $this->pluginEnabled;
    }

    // return Client ID
    function getClient()
    {
        return $this->client;
    }

    // content
    function isContentEnabled()
    {
        return $this->contentEnabled;
    }

    function getContentWidth()
    {
        return $this->contentWidth;
    }

    function getContentHeight()
    {
        return $this->contentHeight;
    }

    function getContentFormat()
    {
        return $this->contentFormat;
    }

    function getContentType()
    {
        return $this->contentType;
    }

    function getContentChannel()
    {
        return $this->contentChannel;
    }

    // suggestion
    function isSuggestionEnabled()
    {
        return $this->suggestionEnabled;
    }

    function getSuggestionWidth()
    {
        return $this->suggestionWidth;
    }

    function getSuggestionHeight()
    {
        return $this->suggestionHeight;
    }

    function getSuggestionFormat()
    {
        return $this->suggestionFormat;
    }

    function getSuggestionChoice()
    {
        return $this->suggestionChoice;
    }

    function getSuggestionChannel()
    {
        return $this->suggestionChannel;
    }

    // search
    function isSearchEnabled()
    {
        return $this->searchEnabled;
    }
}

?>
