<?php

lt_include(PLOG_CLASS_PATH.'class/action/admin/adminaction.class.php');
lt_include(PLOG_CLASS_PATH.'class/view/admin/adminplugintemplatedview.class.php');
lt_include(PLOG_CLASS_PATH.'plugins/googleadsense/class/view/plugingoogleadsenseconfigview.class.php');

// updates the plugin configuration
class PluginGoogleAdsenseUpdateConfigAction extends AdminAction
{
    var $_pluginEnabled;
    var $_client;
    var $_contentEnabled;
    var $_contentWidth;
    var $_contentHeight;
    var $_contentFormat;
    var $_contentType;
    var $_contentChannel;
    var $_suggestionEnabled;
    var $_suggestionWidth;
    var $_suggestionHeight;
    var $_suggestionFormat;
    var $_suggestionChoice;
    var $_suggestionChannel;
    var $_searchEnabled;

	function PluginStickyPostsUpdateConfigAction($actionInfo, $request)
	{
		$this->AdminAction($actionInfo, $request);
	}

	function validate()
	{
        $errorMessages = array();
		$this->_pluginEnabled = $this->_request->getValue('pluginEnabled');
        $this->_pluginEnabled = ($this->_pluginEnabled != '');

		$this->_client = $this->_request->getValue('client');
		if ($this->_pluginEnabled && empty($this->_client)) {
            $errorMessages[] = 'googleadsense_error_client';
			$isError = true;
		}

		$this->_contentEnabled = $this->_request->getValue('contentEnabled');
        $this->_contentEnabled = ($this->_contentEnabled != '');
		$this->_contentWidth = $this->_request->getValue('contentWidth');
		$this->_contentHeight = $this->_request->getValue('contentHeight');
		$this->_contentFormat = $this->_request->getValue('contentFormat');
		$this->_contentType = $this->_request->getValue('contentType');
		$this->_contentChannel = $this->_request->getValue('contentChannel');

		$this->_suggestionEnabled = $this->_request->getValue('suggestionEnabled');
        $this->_suggestionEnabled = ($this->_suggestionEnabled != '');
		$this->_suggestionWidth = $this->_request->getValue('suggestionWidth');
		$this->_suggestionHeight = $this->_request->getValue('suggestionHeight');
		$this->_suggestionFormat = $this->_request->getValue('suggestionFormat');
		$this->_suggestionChoice = $this->_request->getValue('suggestionChoice');
		$this->_suggestionChannel = $this->_request->getValue('suggestionChannel');

		$this->_searchEnabled = $this->_request->getValue('searchEnabled');
        $this->_searchEnabled = ($this->_searchEnabled != '');

		if (count($errorMessages) > 0) {
            $this->_view = new PluginGoogleAdsenseConfigView($this->_blogInfo);
			$allerror='';
			foreach ($errorMessages as $error) {
				$allerror .= $this->_locale->tr($error).'<br />';
			}
            $this->_view->setErrorMessage($this->_locale->tr($allerror));
            $this->setCommonData();
            return false;
        }

        return true;
    }

	function perform()
	{
        // // update the plugin configurations to blog setting
		$blogSettings = $this->_blogInfo->getSettings();
        $blogSettings->setValue('plugin_googleadsense_enabled', $this->_pluginEnabled);
        $blogSettings->setValue('plugin_googleadsense_client', $this->_client);
        $blogSettings->setValue('plugin_googleadsense_content_enabled', $this->_contentEnabled);
        $blogSettings->setValue('plugin_googleadsense_content_width', $this->_contentWidth);
        $blogSettings->setValue('plugin_googleadsense_content_height', $this->_contentHeight);
        $blogSettings->setValue('plugin_googleadsense_content_format', $this->_contentFormat);
        $blogSettings->setValue('plugin_googleadsense_content_type', $this->_contentType);
        $blogSettings->setValue('plugin_googleadsense_content_channel', $this->_contentChannel);
        $blogSettings->setValue('plugin_googleadsense_suggestion_enabled', $this->_suggestionEnabled);
        $blogSettings->setValue('plugin_googleadsense_suggestion_width', $this->_suggestionWidth);
        $blogSettings->setValue('plugin_googleadsense_suggestion_height', $this->_suggestionHeight);
        $blogSettings->setValue('plugin_googleadsense_suggestion_format', $this->_suggestionFormat);
        $blogSettings->setValue('plugin_googleadsense_suggestion_choice', $this->_suggestionChoice);
        $blogSettings->setValue('plugin_googleadsense_suggestion_channel', $this->_suggestionChannel);
        $blogSettings->setValue('plugin_googleadsense_search_enabled', $this->_searchEnabled);
        $this->_blogInfo->setSettings($blogSettings);

        // save the blogs settings
		$blogs = new Blogs();
        if (!$blogs->updateBlog($this->_blogInfo)) {
            $this->_view = new PluginStickyPostsConfigView($this->_blogInfo);
            $this->_view->setErrorMessage($this->_locale->tr('error_updating_settings'));
            $this->setCommonData();
            return false;
        }

		// if everything went ok...
        $this->_blogInfo->setSettings($blogSettings);
        $this->_session->setValue('blogInfo', $this->_blogInfo);
        $this->saveSession();

		$this->_view = new PluginGoogleAdsenseConfigView($this->_blogInfo);
		$this->_view->setSuccessMessage($this->_locale->tr('googleadsense_settings_saved_ok'));
		$this->setCommonData();

		// clear the cache
		CacheControl::resetBlogCache($this->_blogInfo->getId());

        return true;
	}
}

?>
