<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Plugin that offers features such as to return a random image from the 
     * public collections/albums, the latest image added, and so on
     */
    class PluginGalleryImages extends PluginBase
    {
    
        function PluginGalleryImages()
        {
            $this->author = "The LifeType Project";
            $this->desc = "This plugin offers two methods, one for fetching the most recently uploaded image and another one for retrieving a random image from our collection. Needless to say, this plugin only returns images and not any other type of resource. Only images that belong to public albums will be used. <br /><br />You can use the following snippet of template code to show the latest uploaded image in your templates:<br /><br /><b>{assign var=latestImage value=\$galleryimages-&gt;latestImage()}<br />&lt;a href=&quot;{\$url-&gt;resourceLink(\$latestImage)}&quot;&gt;<br />&lt;img style=&quot;border:0px;&quot; src=&quot;{\$url-&gt;resourcePreviewLink(\$latestImage)}&quot; alt=&quot;{\$latestImage-&gt;getDescription()}&quot; /&gt;<br />&lt;/a&gt;</b> <br /><br />To show a random image from your collection, you can use the following snippet: <br /><br /><b>{assign var=randomImage value=\$galleryimages-&gt;randomImage(9)}<br />&lt;a href=&quot;{\$url-&gt;resourceLink(\$randomImage)}&quot;&gt;<br />&lt;img style=&quot;border:0px;&quot; src=&quot;{\$url-&gt;resourcePreviewLink(\$randomImage)}&quot; alt=&quot;{\$randomImage-&gt;getDescription()}&quot; /&gt;<br />&lt;/a&gt;</b></p><p>And, you can use <br /><br /><strong>{\$galleryimages-&gt;randomImage(8)}</strong> to get 1 random image from album id=8, or use <br /><strong>{\$galleryimages-&gt;randomImage(10,3)}</strong> to get the 3 random images from album id=10 </p><p>Or, you also can use</p><p><strong>{\$galleryimages-&gt;lastImage(8)}</strong> to get last 1 upload image from album id=8, or use <br /><strong>{\$galleryimages-&gt;lastImage(10,3)}</strong> to get last 3 upload images from album id=10 <br /><br />";
            $this->id = "galleryimages";
            $this->locales = Array();
            $this->version = "20070226";
            
            $this->PluginBase();
            
            // register an extra action that will serve the images
            
        }
 
        /**
         * Returns the GalleryResource object of the latest image uploaded to the database
         */
        function latestImages( $maxImages = 1, $album_id = 0 )
        {
            lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryresources.class.php" );        
            $resources = new GalleryResources();
            $prefix = $resources->getPrefix();
            $blogId = $this->blogInfo->getId();
            
            // quite a long query here... but we have to choose only images, and from those
            // images, only those that belong to albums that have been set to be shown
            // in the public side
            $query = "SELECT r.id AS id, r.owner_id AS owner_id, r.album_id AS album_id,
                      r.description AS description, r.date AS date, r.flags AS flags,
                      r.resource_type AS resource_type, r.file_path AS file_path,
                      r.file_name AS file_name, r.metadata AS metadata, 
                      r.thumbnail_format AS thumbnail_format
                      FROM {$prefix}gallery_resources r";
            if( $album_id > 0 )
                $query .= ", {$prefix}gallery_albums a";
                
            $query .= " WHERE r.resource_type = 1 AND r.owner_id = '".Db::qstr($blogId)."'";
                      
            if( $album_id > 0 )
                $query .= " AND a.show_album = 1 AND a.id = '".Db::qstr($album_id)."' AND r.album_id = '".Db::qstr($album_id)."'";
                
            $query .= "ORDER BY r.date DESC LIMIT 0, {$maxImages}";
            // just to make things easier, we'll cheat a little here...
            
			lt_include( PLOG_CLASS_PATH."class/database/db.class.php" );
			$db =& Db::getDb();
            $result = $db->Execute( $query );

            if( !$result )
                return false;
                
            $latestimages = Array();
            while( $row = $result->FetchRow()) { 
               array_push( $latestimages, $resources->mapRow( $row )); 
            } 
            
            return $latestimages;
        }
        
        /**
         * Returns only the latest image from the givel album id
         */
        function latestImage( $album_id = 0 )
        {
            $latestImages = $this->latestImages( 1, $album_id );
            
            if( $latestImages ) 
                return( array_pop( $latestImages ));
            else
                return( false );
        }
        
        /**
         * Returns exactly one random image from our collection
         */
        function randomImage( $album_id = 0 )
        {
            $randomImages = $this->randomImages( 1, $album_id );
            
            if( $randomImages )
                return( array_pop( $randomImages ));
            else
                return( false );
        }
        
        /**
         * Returns the GalleryResource object of a random image from one of the public albums
         */
        function randomImages( $maxImages = 1, $album_id = 0 )
        {
            lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryresources.class.php" );        
            $resources = new GalleryResources();
            $prefix = $resources->getPrefix();
            $blogId = $this->blogInfo->getId();
            
            $query = "SELECT r.id AS id, r.owner_id AS owner_id, r.album_id AS album_id,
                      r.description AS description, r.date AS date, r.flags AS flags,
                      r.resource_type AS resource_type, r.file_path AS file_path,
                      r.file_name AS file_name, r.metadata AS metadata, 
                      r.thumbnail_format AS thumbnail_format
                      FROM {$prefix}gallery_resources r";
            if( $album_id > 0 ) 
                $query .= ", {$prefix}gallery_albums a";
            $query .= " WHERE r.resource_type = 1 AND r.owner_id = $blogId";
            if( $album_id > 0 ) {
                $query .=" AND a.show_album = 1 AND r.album_id = '".Db::qstr($album_id)."' AND a.id = '".Db::qstr($album_id)."'";
            }
                      
            $query .=" ORDER BY RAND() LIMIT 0, {$maxImages}";

            // just to make things easier, we'll cheat a little here...
			lt_include( PLOG_CLASS_PATH."class/database/db.class.php" );
			$db =& Db::getDb();
            $result = $db->Execute( $query );

            if( !$result )
                return false;
                
            $randomimages = Array();
            while( $row = $result->FetchRow()) { 
               $randomimages[] = $resources->mapRow( $row );
            }
            
            return $randomimages;
        }
    }
    
?>