<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/feedreader/class/dao/feedreaderdata.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/mylinkscategories.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class FeedListView extends AdminPluginTemplatedView
	{
		var $_categoryId;
	
		function FeedListView( $blogInfo, $categoryId = 0 )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "feedreader", "feedlist" );
			
			$this->_categoryId = $categoryId;
		}
		
		function render()
		{
			// get the feeds based on the chosen category
			$feedData = new FeedReaderData();
			$feeds = $feedData->getBlogFeeds( $this->_blogInfo->getId(), $this->_categoryId );
			
			// get the link categories
			$linkCategories = new MyLinksCategories();
			$blogLinkCategories = $linkCategories->getMyLinksCategories( $this->_blogInfo->getId());
			
			// show the list with the categories available
			$this->setValue( "feeds", $feeds );
			$this->setValue( "linkscategories", $blogLinkCategories );
			$this->setValue( "currentcategory", $this->_categoryId );
			
			parent::render();
		}
	}
?>