<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	
	class PluginCopyArticle extends PluginBase
	{
		function PluginCopyArticle( $source )
		{
			$this->PluginBase( $source );
			
			$this->id = "copyarticle";
			$this->version = "20070315";
			$this->author = "The LifeType Project";
			$this->desc = "Provides extra functionality in the \"Edit Post\" screen to copy an article.";
			
			if( $source == "admin" ) {
				// hook up to our event
				$this->registerNotification( EVENT_PROCESS_BLOG_ADMIN_TEMPLATE_OUTPUT );
				// and register a new admin action
				$this->registerAdminAction( "copyArticle", "AdminCopyArticleAction" );
			}
		}
		
		function process( $event, $params )
		{
			// only process the "editposts" template
			if( $params["template"] != "editposts" )
				return;

			// load the current contents of the template
			$content = $params["content"];
						
			$regexp = "/<div class=\"list_action_button\">.*?<\/div>/s";
			
			preg_match_all( $regexp, $content, $matches, PREG_SET_ORDER );

			//print_r($matches);			
			
			// now process each one of the matches and do the replacements...
			foreach( $matches as $match ) {
				// fetch the article id 
				$res = preg_match( "/<a href=\"\?op=editPost&amp;postId=([0-9]+)\"/i", $match[0], $result );
				if( $res ) {
					// regenerate the block, adding the new markup
					$artId = $result[1];
					$toAdd = "<a href=\"?op=copyArticle&amp;postId={$artId}\"><img src=\"plugins/copyarticle/imgs/copy.png\" alt=\"copy\" /></a></div>";
					$newStr = str_replace( "</div>", $toAdd, $match[0] );
					// and now replace the old block with the new one in the global $content variable
					$content = str_replace( $match[0], $newStr, $content );
				}
			}
			
			$params["content"] = $content;
		}
	}
?>