<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/admin/adminpostslistview.class.php" );	
    lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );

	class AdminCopyArticleAction extends AdminAction
	{
		function AdminCopyArticleAction( $actionInfo, $request ) 
		{
			$this->AdminAction( $actionInfo, $request );
			
			$this->registerFieldValidator( "postId", new IntegerValidator());
        	$view = new AdminPostsListView( $this->_blogInfo );
        	$view->setErrorMessage( $this->_locale->tr("error_incorrect_article_id"));
        	$this->setValidationErrorView( $view );			
		}
		
		function perform()
		{
	        // fetch the post id that has already been validated
	     	$postId = $this->_request->getValue( "postId" );   
	        
        	// fetch the post from the database
            $posts = new Articles();
            $post  = $posts->getBlogArticle( $postId, $this->_blogInfo->getId(), false );

            // if the article does not exist, quit
            if( !$post ) {
            	$this->_view = new AdminPostsListView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_fetching_article" ));
                $this->setCommonData();

                return false;
            }

			// if the article was found:
			// 		remove its current id
			//		set the status to 'draft'
			//		reset its counters (num reads, comment and trackback counters)
			$post->setId( -1 );
			$post->setStatus( POST_STATUS_DRAFT );
			$post->setTotalComments( 0 );
			$post->setTotalTrackbacks( 0 );
			$post->setNumComments( 0 );
			$post->setNumTrackbacks( 0 );			
			$post->setNumReads( 0 );
			
			// and save it again
			if( !$posts->addArticle( $post )) {
            	$this->_view = new AdminPostsListView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_copying_article" ));
                $this->setCommonData();

                return( false );
			}
			
        	$this->_view = new AdminPostsListView( $this->_blogInfo );
            $this->_view->setSuccessMessage( $this->_locale->tr("article_copied_ok" ));
            $this->setCommonData();
			return( true );			
		}		
	}
?>