<?php
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PlugincoComment extends PluginBase
	{
		var $pluginEnabled;
		
		function PlugincoComment($source = "")
		{
			$this->PluginBase($source);

			$this->id      = "cocomment";
			$this->author  = "James Huang";
			$this->desc    = "Integrate cocomment into LifeType commentform template.";
            $this->version = "20070801";
			$this->locales = Array( "en_UK" , "zh_TW" );
            
            if($source == "admin")
				$this->initAdmin();
			else
				$this->init();
		}

		function initAdmin(){
            $this->registerAdminAction( "coCommentConfig", "PlugincoCommentConfigAction" );
			$this->registerAdminAction( "updatecoCommentConfig", "PlugincoCommentUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "coComment", "?op=coCommentConfig", "" );
		}

		function init(){
            $this->registerBlogAction( "coComment", "ShowcoCommentAction" );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_cocomment_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function show($postId)
	    {

			$str = '';
	    
            if ($this->isEnabled())
            {
            
                // articles object
                $articles = new Articles;
    
    
                $rg = $this->blogInfo->getBlogRequestGenerator();
                $post = $articles->getBlogArticle($postId);
    
                $str = '<script type="text/javascript">';
                $str .= 'coco =';
                $str .= '{';
                $str .= 'tool       : "LifeType",';
                $str .= 'siteurl    : "'.$rg->blogLink().'",';
                $str .= 'sitetitle  : "'.$this->blogInfo->getBlog().'",';
                $str .= 'pageurl    : "'.$rg->postPermalink($post).'",';
                $str .= 'pagetitle  : "'.$post->getTopic().'",';
                $str .= 'authorID   : "userName";';
             // $str .= 'var commentAuthorLoggedIn = false;';
                $str .= 'formID      : "NewComment",';
                $str .= 'textareaName: "commentText",';
                $str .= 'buttonName  : "Add"';
                $str .= '}';
    //			$str .='var cocomment_force = false;';
                $str .= '</script>';
                $str .='<script id="cocomment-fetchlet" src="http://www.cocomment.com/js/enabler.js" type="text/javascript"></script>';
                $str .= '</script>';
            }
	    	return $str;
		}
	}
?>