<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/closecomments/class/security/closecomments.class.php" );
	
	//
	// if no value was defined, let's close comments after 14 days
	//
	define( "DEFAULT_CLOSECOMMENTS_PERIOD", 14 );
	
	class PluginCloseComments extends PluginBase
	{
		function PluginCloseComments( $source )
		{
			$this->PluginBase( $source );
	
			$this->id = "closecomments";
			$this->author = "The LifeType Team";
			$this->version = "20070331";
			$this->desc = "Allows to automatically close comments for posts that are older than a configurable certain date";
			
			// register our admin actions and menu entries			
			if( $this->getSource() == "admin" ) {
				
                $menu =& Menu::getMenu();
                if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))						
                    $this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "" );
				$this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "closeComments", "?op=closeCommentsSettings" );
				
				$this->registerAdminAction( "closeCommentsSettings", "AdminCloseCommentsSettingsAction" );
				$this->registerAdminAction( "updateCloseCommentsSettings", "AdminUpdateCloseCommentsSettingsAction" );				
							
				// register the needed event
				$this->registerNotification( EVENT_POST_LOADED );
			}

			$this->registerFilter( "CloseComments" );
		}
		
		/**
		 * process the EVENT_POST_LOADED event and deactivate the comments
		 * if necessary
		 */
		function process( $event, $params )
		{
			if( $event != EVENT_POST_LOADED )
				return( false );
				
			$settings = $this->blogInfo->getSettings();
			if( !$settings->getValue( "plugin_closecomments_enabled", false ))
				return false;
			
			// get the post and check if we should close its comments, based on the current settings
			$article = $params["article"];
			$postDate = $article->getDateObject();
			$period = $settings->getValue( "plugin_closecomments_period", DEFAULT_CLOSECOMMENTS_PERIOD );
			$postDate->addSeconds( $period * 24 * 3600 );
			$now = new Timestamp();
			
			//print("date+period = ".$postDate->getTimestamp()." - now = ".$now->getTimestamp()."<br/>");
			
			if( $postDate->getTimestamp() < $now->getTimestamp()) {
				//print( "Closing comments!" );
				lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
				if( $article->getCommentsEnabled()) {
					$article->setCommentsEnabled( false );
					$articles = new Articles();
					$articles->updateArticle( $article );				
				}
			}
			
			$params["article"] = $article;			
		}
		
		/**
		 * Report our global configuration keys, in case administrators want to 
		 * globally enable this plugin
		 */
		function getPluginConfigurationKeys()
		{
			lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );			
			
			return( Array(
				Array( "name" => "plugin_closecomments_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_closecomments_period", 
				       "validator" => new IntegerValidator(), 
				       "type" => "list",
				       "options" => Array( "1" => "1 day", "7" => "1 week" , "14" => "2 weeks", "30" => "1 month" ))
			));			
		}
	}
?>