<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/categorycloud/class/view/plugincategorycloudconfigview.class.php" );	
			
	/**
	 * updates the plugin configuration
	 */
	class PluginCategoryCloudUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
        var $_minFont;
        var $_maxFont;
        var $_minWeight;
        var $_maxWeight;
		
		function PluginCategoryCloudUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );	

            $this->_minFont = $this->_request->getValue( "minFont" );

            $this->_maxFont = $this->_request->getValue( "maxFont" );

            $this->_minWeight = $this->_request->getValue( "minWeight" );
            
            $this->_maxWeight = $this->_request->getValue( "maxWeight" );

            return true;
		}
		        
		function perform()
		{
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_categorycloud_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_categorycloud_min_size", $this->_minFont );
            $blogSettings->setValue( "plugin_categorycloud_max_size", $this->_maxFont );
            $blogSettings->setValue( "plugin_categorycloud_min_weight", $this->_minWeight );
            $blogSettings->setValue( "plugin_categorycloud_max_weight", $this->_maxWeight );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginCategoryCloudConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginCategoryCloudConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("categorycloud_settings_saved_ok"));
			$this->setCommonData();

			$plugins = $this->_pm->getPlugins();

            $plugin = $plugins["categorycloud"];
            $plugin->createCloud();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
		
		function isValidColor($colorCode) {
		    $pattern = "#[a-fA-F0-9]{6}";
		    $length = strlen($colorCode);
            if (ereg ($pattern, $colorCode) && $length == 7) {
               return true;
            } else {
               return false;
            }
	    }
	}
?>
