<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class PluginBlogTimesConfigView extends AdminPluginTemplatedView
	{

		function PluginBlogTimesConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "blogtimes", "blogtimes" );
		}
		
		function render()
		{
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_blogtimes_enabled" );
			$backColor = $blogSettings->getValue( "plugin_blogtimes_backcolor" );
			if ($backColor == "") $backColor = "#FFFFFF";
			$boxColor = $blogSettings->getValue( "plugin_blogtimes_boxcolor" );
			if ($boxColor == "") $boxColor = "#666666";
			$textColor = $blogSettings->getValue( "plugin_blogtimes_textcolor" );
			if ($textColor == "") $textColor = "#000000";
			$lineColor = $blogSettings->getValue( "plugin_blogtimes_linecolor" );
			if ($lineColor == "") $lineColor = "#FFFFFF";
			$borderColor = $blogSettings->getValue( "plugin_blogtimes_bordercolor" );
			if ($borderColor == "") $borderColor = "#666666";
			$tickColor = $blogSettings->getValue( "plugin_blogtimes_tickcolor" );
			if ($tickColor == "") $tickColor = "#666666";
			$title = $blogSettings->getValue( "plugin_blogtimes_title" );
			if ($title == "") $title = "Blog Post Times";
			$width = $blogSettings->getValue( "plugin_blogtimes_width" );
			if ($width == "") $width = 480;
			$height = $blogSettings->getValue( "plugin_blogtimes_height" );
			if ($height == "") $height = 65;
			$lastDays = $blogSettings->getValue( "plugin_blogtimes_lastdays" );
			if ($lastDays == "") $lastDays = "30";
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "backColor", $backColor );
			$this->setValue( "boxColor", $boxColor );		
			$this->setValue( "textColor", $textColor );
			$this->setValue( "lineColor", $lineColor );
			$this->setValue( "borderColor", $borderColor );
			$this->setValue( "tickColor", $tickColor );
			$this->setValue( "title", $title );
			$this->setValue( "width", $width );
			$this->setValue( "height", $height );
			$this->setValue( "lastDays", $lastDays );

			parent::render();
		}
	}
?>