<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/blogtimes/class/view/pluginblogtimesconfigview.class.php" );	
			
	/**
	 * updates the plugin configuration
	 */
	class PluginBlogTimesUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
        var $_backColor;
        var $_boxColor;
        var $_textColor;
        var $_lineColor;
        var $_borderColor;
        var $_tickColor;
        var $_title;
        var $_lastDays;
		
		function PluginBlogTimesUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $error = 0;
            
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );	

            $this->_backColor = $this->_request->getValue( "backColor" );
            if( !$this->isValidColor($this->_backColor) ) $error = 1;
            
            $this->_boxColor = $this->_request->getValue( "boxColor" );
            if( !$this->isValidColor($this->_boxColor) ) $error = 1;
            
            $this->_textColor = $this->_request->getValue( "textColor" );
            if( !$this->isValidColor($this->_textColor) ) $error = 1;

            $this->_lineColor = $this->_request->getValue( "lineColor" );
            if( !$this->isValidColor($this->_lineColor) ) $error = 1;

            $this->_borderColor = $this->_request->getValue( "borderColor" );
            if( !$this->isValidColor($this->_borderColor) ) $error = 1;
            
            $this->_tickColor = $this->_request->getValue( "tickColor" );
            if( !$this->isValidColor($this->_tickColor) ) $error = 1;            

            if( $error ) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("blogtimes_error_color_code"));
                $this->setCommonData();

                return false;
            }

            $this->_title = $this->_request->getValue( "title" ); 
            if ( $this->_title == "" ) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("blogtimes_error_title"));
                $this->setCommonData();

                return false;
            }

            $this->_width = $this->_request->getValue( "width" ); 
            if ( $this->_width < 240 || !ctype_digit($this->_width) ) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("blogtimes_error_width"));
                $this->setCommonData();

                return false;
            }

            $this->_height = $this->_request->getValue( "height" ); 
            if ( $this->_height < 30 || !ctype_digit($this->_height) ) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("blogtimes_error_height"));
                $this->setCommonData();

                return false;
            }            
            $this->_lastDays = $this->_request->getValue( "lastDays" ); 
            if ( $this->_lastDays < 0 || !ctype_digit($this->_lastDays) ) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("blogtimes_error_last_days"));
                $this->setCommonData();

                return false;
            }
            
            return true;
		}
		        
		function perform()
		{
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_blogtimes_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_blogtimes_backcolor", $this->_backColor );
            $blogSettings->setValue( "plugin_blogtimes_boxcolor", $this->_boxColor );
            $blogSettings->setValue( "plugin_blogtimes_textcolor", $this->_textColor );
            $blogSettings->setValue( "plugin_blogtimes_linecolor", $this->_lineColor );
            $blogSettings->setValue( "plugin_blogtimes_bordercolor", $this->_borderColor );
            $blogSettings->setValue( "plugin_blogtimes_tickcolor", $this->_tickColor );
            $blogSettings->setValue( "plugin_blogtimes_title", $this->_title );
            $blogSettings->setValue( "plugin_blogtimes_width", $this->_width );
            $blogSettings->setValue( "plugin_blogtimes_height", $this->_height );
            $blogSettings->setValue( "plugin_blogtimes_lastdays", $this->_lastDays );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginBlogTimesConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("blogtimes_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
		
		function isValidColor($colorCode) {
		    $pattern = "#[a-fA-F0-9]{6}";
		    $length = strlen($colorCode);
            if (ereg ($pattern, $colorCode) && $length == 7) {
               return true;
            } else {
               return false;
            }
	    }
	}
?>