<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomabstractservice.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/users.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	
	if( !defined( "ADMIN_PERMISSION" )) 
		define( "ADMIN_PERMISSION", 1 );
	if( !defined( "BLOG_PERMISSION" )) 
		define( "BLOG_PERMISSION", 2 );	
	
	/**
	 * plog-dependent class that starts messing around with blogs and users. So far the layer
	 * was pretty generic but at some point we have to get into plog... and it is here :)
	 */
	class PlogAtomAbstractService extends AtomAbstractService 
	{
		var $_userInfo;
		var $_blogInfo;
		var $_blogInfos;
	 
		function PlogAtomAbstractService( $request )
		{
			$this-> AtomAbstractService( $request );
			
			// load the information we need from the user and the blog
			$this->_loadInfo();	
		}
		
		/**
		 * @private
		 */
		function _loadInfo()
		{
			// loads the blog information and the user information based on what
			// came from the request
			
			// first, get the username from the authentication layer
			$userName = $this->_request->getUsernameFromAuthentication();
			AtomLogger::Log( "PlogAtomAbstractService:_loadInfo: username = $userName" );

			// load user information for the user
			$users = new Users();
			$this->_userInfo = $users->getUserInfoFromUsername( $userName );
			if( !$this->_userInfo ) {
				AtomLogger::Log( "Error loading the user information" );
				$response = new AtomErrorResponse( "Error loading user information",
                                                                    HTTP_ERROR_500 );
				$this->setResponse( $response );
				$this->_isInitError = true;
				return false;
			}

			$blogs = new Blogs();
			$blogId = $this->_request->getBlogId();
			$userId = $this->_userInfo->getId();
			if( $blogId == ATOM_NO_BLOG) {
				AtomLogger::Log( "Loading all blogs for user ".$this->_userInfo->getUsername());
				$this->_blogInfos = $users->getUsersBlogs( $userId );
			}
			else {
				AtomLogger::Log( "Loading blog with id = ".$blogId );
				$this->_blogInfo = $blogs->getBlogInfo( $blogId );
			}

			return true;
		}
		
		/**
		 * Returns the current BlogInfo object
		 *
		 * @return A BlogInfo object
		 */
		function getBlogInfo()
		{
			return $this->_blogInfo;
		}
		
		/**
		 * Returns the current UserInfo object
		 *
		 * @return A UserInfo object
		 */
		function getUserInfo()
		{
			return $this->_userInfo;
		}
		
		/**
		 * Extra helper method to check permissions
		 *
		 * @param user A UserInfo object
		 * @param blog A BlogInfo object
		 * @param permName Name of the permission
		 * @param mode Either BLOG_PERMISSION or ADMIN_PERMISSION, depending on whether
		 * we're checking the user's permissions in this blog or an admin permission
		 */
		function userHasPermission( $permName, $mode = BLOG_PERMISSION )
		{			
			// check for the permission, whether the user is the blog owner or
			// whether the user is a site administrator
			$hasPermission = false;
			if( $mode == BLOG_PERMISSION ) {
		    	$hasPermission = ( 
		    		$this->_userInfo->hasPermissionByName( $permName, $this->_blogInfo->getId()) ||
		    		$this->_blogInfo->getOwnerId() == $this->_userInfo->getId() ||
					$this->_userInfo->hasPermissionByName( "edit_blog_admin_mode", 0 )
		    	);
			}
			else {				
		    	$hasPermission = ( $this->_userInfo->hasPermissionByName( $permName, 0 ));
			}
		
			return( $hasPermission );
		}		
	}
?>