<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/plogatomabstractservice.class.php" );
	
	class FeedService extends PlogAtomAbstractService 
	{
	
		function FeedService( $request )
		{
			$this->PlogAtomAbstractService( $request );
		}
		
		/**
		 * provides with a feed of the blog
		 */
		function doGet()
		{
			lt_include( PLOG_CLASS_PATH."plugins/atom/class/template/atomoutputrenderer.class.php" );	
			lt_include( PLOG_CLASS_PATH."plugins/atom/class/net/atomrequestgenerator.class.php" );
			lt_include( PLOG_CLASS_PATH."class/dao/users.class.php" );
			lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
			lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
			lt_include( PLOG_CLASS_PATH."class/data/timestamp.class.php" );
		
			$output = new AtomOutputRenderer( "feed" );
			$output->setValue( "blog", $this->_blogInfo );
			$output->setValue( "user", $this->_userInfo );
			$output->setValue( "url", new AtomRequestGenerator( $this->getBlogInfo()));
			$articles = new Articles();
			$t = new Timestamp();
			$blogArticles = $articles->getBlogArticles( $this->_blogInfo->getId(), // blog
			                                            -1,  // date
			                                            20,  // amount, should probably use blogSettings
			                                            0,   // categoryId
			                                            POST_STATUS_PUBLISHED,  // status
			                                            0,   // userId
			                                            $t->getTimestamp() // max date
			                                            );
			                                             
			$output->setValue( "articles", $blogArticles );
			
			// set the response
			$response = new AtomResponse( $output->fetch());
			$this->setResponse( $response );
			
			return true;
		}
	}
?>