<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/plogatomabstractservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/template/atomoutputrenderer.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/net/atomrequestgenerator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/users.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
	lt_include( PLOG_CLASS_PATH."class/template/cachecontrol.class.php" );	
	
	class EditService extends PlogAtomAbstractService 
	{
	
		function EditService( $request )
		{
			$this->PlogAtomAbstractService( $request );
		}
		
		/**
		 * returns a single article
		 */
		function doGet()
		{
			$articleId = $this->_request->getArticleId();

			$output = new AtomOutputRenderer( "article" );
			$output->setValue( "blog", $this->_blogInfo );
			$output->setValue( "user", $this->_userInfo );
			$output->setValue( "url", new AtomRequestGenerator( $this->getBlogInfo()));

			$articles = new Articles();
			$articleId = $this->_request->getArticleId();
			$blogId = $this->_blogInfo->getId();
			$article = $articles->getBlogArticle( $articleId, $blogId );
			if( !$article ) {
				// send an invalid response
				$response = new AtomErrorResponse( "Article with id $articleId not found",
                                                   HTTP_ERROR_400 );
				$this->setResponse( $response );
				return false;
			}
			                                             
			$output->setValue( "article", $article );
			
			// clear the cache no matter what happened
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
			
			// set the response
			$response = new AtomResponse( $output->fetch());
			$this->setResponse( $response );
			
			return true;
		}
		
		/**
		 * removes an article from the blog
		 */
		function doDelete()
		{
			// check if the user has posting permissions
			if( !$this->userHasPermission( "update_post" )) {
				AtomLogger::Log( "User does not have update_post permission" );
				$response = new AtomErrorResponse( "You do not have enough permissions to perform this operation", HTTP_ERROR_500 );
				$this->setResponse( $response );		       
				return false;				
			}			

			// get the article id
			$articleId = $this->_request->getArticleId();
			AtomLogger::Log( "Removing article with id $articleId" );

			$articles = new Articles();
			if( !$articles->deleteArticle( $articleId, $this->_userInfo->getId(), $this->_blogInfo->getId())) {
				AtomLogger::Log( "There was an error removing the article" );
				$response = new AtomErrorResponse( "Error removing article with identifier $articleId",
				HTTP_ERROR_500 );
				$this->setResponse( $response );
				return false;
			}

			// a response only needs an HTTP 200 OK to acknowledge that the post was removed successfully
			AtomLogger::Log( "Article removed successfully" );
			$response = new AtomResponse( "Article deleted OK", Array( HTTP_OK_200 ));
			$this->setResponse( $response );

			CacheControl::resetBlogCache( $this->_blogInfo->getId());

			return true;
		}
		
		/**
		 * updates an article in the blog via a PUT request
		 */
		function doPut()
		{
			// check if the user has posting permissions
			if( !$this->userHasPermission( "update_post" )) {
				AtomLogger::Log( "User does not have update_post permission" );
				$response = new AtomErrorResponse( "You do not have enough permissions to perform this operation", HTTP_ERROR_500 );
				$this->setResponse( $response );		       
				return false;				
			}			
			
			$articleId = $this->_request->getArticleId();
			$blogId = $this->_blogInfo->getId();			
			AtomLogger::Log( "Attempting to update article $articleId in blog $blogId" );
			
			// load the article
			$articles = new Articles();
			$article = $articles->getBlogArticle( $articleId, $blogId );
			if( !$article ) {
				AtomLogger::Log( "There was an error loading article $articleId for updating!" );
				$response = new AtomErrorResponse( "Article not found", HTTP_ERROR_400 );
				$this->setResponse( $response );
				
				return false;
			}
			
			// if everything went fine, then we can see what's coming in the request
		    $document = $this->_request->getAtomDocument();
		    $contents = $document->content;					
		    $text  = $contents[0]->text;
		    AtomLogger::Log( "updating to contents = $text" );
		    $title = $document->title->text;
		    AtomLogger::Log( "updating to title = $title" );
			
			$article->setTopic( $title );
			$article->setText( $text );
			$article->setDateObject($article->getDateObject());			
			
			if( !$articles->updateArticle( $article )) {
				AtomLogger::Log( "There was an error updating $articleId!" );
				$response = new AtomErrorResponse( "Error updating article", HTTP_ERROR_500 );
				$this->setResponse( $response );
				
				return false;			
			}
			
			// if everythign went fine, then just say so :)
			AtomLogger::Log( "Article updated successfully!" );
			$response = new AtomResponse( "Article updated OK", Array( HTTP_OK_200 ));
			$this->setResponse( $response );
			
		  CacheControl::resetBlogCache( $this->_blogInfo->getId());			
			
			return true;
		}
	}
?>