<?php

	
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomrequest.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomresponse.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomerrorresponse.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomconstants.properties.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/defaultservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/feedservice.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/categoriesservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/editservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/postservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/plogatomauthentication.class.php" );
	
	/**
	 * Array with all the services implemented so far
	 */
	/**
	 * class that handles all the atom requests
	 */
	class AtomServer
	{
	
		var $_response;
		var $_request;

		function AtomServer()
		{
			$this->_response = null;
			$this->_request  = null;
		}
		
		/**
		 * processes incoming atom requests
		 *
		 * @param request The incoming http request with the atom information
		 */
		function processRequest( $request = null )
		{
			// array with all the services implemented so far
			$atomServices = Array( "default"    => "DefaultService",
			                       "feed"       => "FeedService",
			                       "edit"       => "EditService",	
			                       "categories" => "CategoriesService",
			                       "post" 	    => "PostService" );

			// check if the request authenticated ok
			if( !$request->isAuthenticated()) {
				$this->_response = new AtomErrorResponse( "Authentication required", HTTP_ERROR_401 );
				return false;
			}
			
			// check if the request was correct
			if( $request->isAtomError()) {
			     $this->_response = new AtomErrorResponse( $request->getAtomErrorMessage(), HTTP_ERROR_400 );
			     return false;
			}

			$this->_request = $request;
			
			// find out the service...
			$serviceId = $request->getService();
			if( $serviceId == null || $serviceId == "" )
				$serviceId = "default";			

			// but first make sure that it exists!
			if( !array_key_exists( $serviceId, $atomServices )) {
			     // and if not, throw an error
			     $this->_response = new AtomErrorResponse( "Unrecognized service '$serviceId'", HTTP_ERROR_500 );
			}
			else {
			     // ...instantiate the right service manager class...			
			     $service = $atomServices["$serviceId"];					
			     $this->_service = new $service( $this->_request );
    			 // ...and use it to process this request
    	   		 $this->_service->process();
			     $this->_response = $this->_service->getResponse();
    	    }
		}
		
		/**
		 * return the response
		 *
		 * @return An AtomResponse object with information about what should be returned to the client
		 */
		function getResponse()
		{
			return $this->_response;
		}
		
	}
?>