<?php

	/**
	 * various constants used by the Atom server
	 */

    /**
     * request type identifiers, used internally
     */
	define( "ATOM_REQUEST_GET", 1 );
	define( "ATOM_REQUEST_POST", 2 );
	define( "ATOM_REQUEST_PUT", 3 );
	define( "ATOM_REQUEST_DELETE", 4 );
	
	/**
	 * default content type returned to clients
	 */
	define( "ATOM_DEFAULT_CONTENT_TYPE", "application/x.atom+xml" );
	define( "ATOM_ERROR_MESSAGES_CONTENT_TYPE", "text/html" );
	
	/**
	 * http error messages
	 */
    define( "HTTP_ERROR_500", "500 Internal Server Error" );
    define( "HTTP_ERROR_404", "404 Not found" );
    define( "HTTP_ERROR_400", "400 Invalid Request" );
    define( "HTTP_ERROR_520", "520 Status Code Undefined" );
    define( "HTTP_ERROR_405", "405 Method Not Allowed" );
    define( "HTTP_ERROR_401", "401 WSSE Authentication Required" );

	/**
	 * http success messages
	 */
    define( "HTTP_OK_201", "201 Created" );
    define( "HTTP_OK_200", "200 OK" );
    
    /**
     * whether authentication should be enabled or not
     * it's advisable to set it to 'false' :)
     */
    define( "WSSE_AUTHENTICATION_DISABLED", false );
    
    /**
     * all the different encoding modes
     */
    define( "ATOM_CONTENT_MODE_ESCAPED", "escaped" );
    define( "ATOM_CONTENT_MODE_BASE64", "base64" );
    define( "ATOM_CONTENT_MODE_XML", "xml" );
    
    /**
     * default name of the album where uploaded files will be
     * assigned to
     */
    define( "ATOM_DEFAULT_ALBUM_NAME", "Moblog" ); 

	define( "ATOM_NO_BLOG", 0 );
	define( "ATOM_NO_ARTICLE", 0 );
	
	/**
	 * how should images be embedded in posts
	 */
	define( 'ATOM_EMBED_SMALL_PREVIEW', 1 );
	define( 'ATOM_EMBED_MEDIUM_PREVIEW', 2 );
	define( 'ATOM_EMBED_FULL_SIZE_VIEW', 3 );
?>