<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomrequest.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/logger/atomlogger.class.php" );

	/**
	 * encapsulates an atom service
	 */
	class AtomAbstractService
	{
	
		var $_request;
		var $_response;
		var $_isInitError;
		
		/**
		 * intializes the service
		 */
		function AtomAbstractService( $request )
		{
			$this->_request = $request;
			$this->_isInitError = false;
			
			
		}
		
		function process()
		{
			if( $this->_isInitError )
				return false;	

			switch( $this->_request->getType()) {
				case ATOM_REQUEST_GET:
					$this->doGet();
					break;
				case ATOM_REQUEST_POST:
					$this->doPost();
					break;
				case ATOM_REQUEST_PUT:
					$this->doPut();
					break;
				case ATOM_REQUEST_DELETE:
					$this->doDelete();
					break;
				default:
					// dunno how safe it is to assume the following but we'll leave
					// it like this for the time being...
					$this->doGet();
					break;
				}
				
				return true;
		}
		
		/**
		 * handles POST requests. Depending on the service, this can be anything
		 */
		function doGet()
		{
		
		}
		
		/**
		 * handles POST requests. Depending on the service, this can be anything
		 */
		function doPost()
		{
		
		}

		/**
		 * handles POST requests. Depending on the service, this can be anything
		 */		
		function doPut()
		{
		
		}

		/**
		 * handles POST requests. Depending on the service, this can be anything
		 */		
		function doDelete()
		{
		
		}
		
		/**
		 * returns true if the user was authenticated correctly or false otherwise
		 *
		 * @return True if the user was authenticated correctly or false otherwise. It is left
		 * up to the different services to implement authentication as they see fit. By default,
		 * everything goes always fine
		 */
		function isAuthenticated()
		{
			return true;
		}
		
		/**
		 * Sets the response that will be returned to the Atom server
		 *
		 * @param response An AtomResponse object
		 */
		function setResponse( $response )
		{
			$this->_response = $response;
		}
		
		/**
		 * returns an AtomResponse object generated by the current service
		 *
		 * @return AtomResponse
		 */
		function getResponse()
		{
			return $this->_response;
		}
	}
?>