<?php

	lt_include( PLOG_CLASS_PATH."class/template/smarty/Smarty.class.php" );
    lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );

    class AtomOutputRenderer extends Smarty 
    {

		var $_templateFile;

		function AtomOutputRenderer( $templateFile )
        {
        	// create the Smarty object and set the security values
			$this->Smarty();
            $this->caching = false;
            $config =& Config::getConfig();
            $this->cache_dir = $config->getValue( "temp_folder" );
            
            $this->_templateFile = $templateFile.".template";

            // enable the security settings
            $this->php_handling = false;

            // default folders
            $this->compile_dir  = $config->getValue( "temp_folder" );
            $this->template_dir = "./plugins/atom/templates/";
            $this->use_sub_dirs = false;
        }

        /**
         * By default templates are searched in the folder specified by the
         * template_folder configuration setting, but we can force Smarty to
         * look for those templates somewhere else. This method is obviously to be
         * used *before* rendering the template ;)
         *
         * @param templateFolder The new path where we'd like to search for templates
         * @return Returns always true.
         */
        function setTemplateDir( $templateDir )
        {
        	$this->template_dir = $templateDir;

            return true;
        }

        /**
         * Returns the name of the template file
         *
         * @return The name of the template file
         */
        function getTemplateFile()
        {
        	return $this->_templateFile;
        }

        /**
         * Renders the template and returns the contents as an string
         *
         * @return The result as an string
         */
        function fetch()
        {
        	return Smarty::fetch( $this->_templateFile );
        }
        
        /**
         * exports a variable to the template
         *
         * @param key
         * @param value
         * @return Always true
         */
        function setValue( $key, $value )
        {
        	$this->assign( $key, $value );
        	
        	return true;
        }
    }
?>
