<?php

	lt_include( PLOG_CLASS_PATH."class/net/rawrequestgenerator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/net/url.class.php" );
	
	/**
	 * Generates a few additional useful urls, extending the original
	 * RequestGenerator
	 */
	class AtomRequestGenerator extends RawRequestGenerator
	{
	
		function AtomRequestGenerator( $blogInfo = null, $mode = CHECK_CONFIG_REQUEST_MODE )
		{
			$this->RawRequestGenerator( $blogInfo, $mode );
			
			$this->_blogInfo = $blogInfo;
		}
		
		/**
		 * returns the entry point to the atom interface
		 */		
		function atomBaseUrl()
		{
			$baseUrl = $this->getBaseUrl();
			$atomBaseUrl = $baseUrl."/atom.php";
			
			return $atomBaseUrl;
		}
		
		/**
		 * @see atomBaseUrl
		 */		
		function getRootEntryPoint()
		{
			return $this->atomBaseUrl();
		}
		
		/**
		 * @return the url of the service.post service
		 */
		function servicePostUrl( $blogInfo = null )
		{
			if( $blogInfo == null )
				$blogInfo = $this->_blogInfo;

			return $this->atomBaseUrl()."/post/".$blogInfo->getId();
		}
		
		/**
		 * @return the url of the service.feed service
		 */
		function serviceFeedUrl( $blogInfo = null )
		{
			if( $blogInfo == null )
				$blogInfo = $this->_blogInfo;

			return $this->atomBaseUrl()."/feed/".$blogInfo->getId();
		}
		
		/**
		 * @return the url of the service.upload service
		 */
		function serviceUploadUrl( $blogInfo = null )
		{
			if( $blogInfo == null )
				$blogInfo = $this->_blogInfo;

			return $this->atomBaseUrl()."/upload/".$blogInfo->getId();
		}
		
		/**
		 * @return the url of the service.categories service
		 */
		function serviceCategoriesUrl( $blogInfo = null )
		{
			if( $blogInfo == null )
				$blogInfo = $this->_blogInfo;

			return $this->atomBaseUrl()."/categories/".$blogInfo->getId();
		}
		
		/**
		 * atom edit url for a given post
		 *
		 * @param article 
		 * @return The service.edit url for a post
		 */
		function atomPostEditUrl( $article )
		{
			return $this->atomBaseUrl()."/edit/".$this->_blogInfo->getId()."/".$article->getId();
		}
		
		/**
		 * atom edit url for a given post
		 *
		 * @param article 
		 * @return The service.edit url for a post
		 */
		function atomBinaryPostEditUrl( $resource )
		{
			return $this->atomBaseUrl()."/editres/".$this->_blogInfo->getId()."/".$resource->getId();
		}
		
		
		/**
		 * generates a unique atom id for the entry. This is not as easy
		 * as it sounds, take a look http://diveintomark.org/archives/2004/05/28/howto-atom-id
		 *
		 * @param article An Article object
		 * @return A unique atom article id
		 */
		function getAtomUniqueId( $article )
		{
		      $config =& Config::getConfig();
		      $url = new Url($config->getValue( "base_url" ));
		      $articleDate = $article->getDateObject();
			  $month = $articleDate->getMonth();
			  if( $month < 10 && strlen($month) < 2)
				$month = "0".$month;
			  $day = $articleDate->getDay();
			  if( $day < 10 && strlen($day) < 2)
				$day = "0".$day;				
				
		      $date = $articleDate->getYear()."-".$month."-".$day;
		      $tag = "tag:post:".$url->getHost().",".$date.":".$article->getId();
		      
		      return $tag;
		}
		
		/**
		 * returns a unique id for a resource
		 *
		 * @param resource
		 * @return A unique tag id
		 */
		function getAtomResourceUniqueId( $resource ) 
		{
		      $config =& Config::getConfig();
		      $url = new Url($config->getValue( "base_url" ));
		      $date = $resource->getTimestamp();
			  $month = $date->getMonth();
			  if( $month < 10 && strlen($month) < 2)
				$month = "0".$month;
			  $day = $date->getDay();
			  if( $day < 10 && strlen($day) < 2)
				$day = "0".$day;

		      $dateString = $date->getYear()."-".$month."-".$day;
		      $tag = "tag:resource:".$url->getHost().",".$dateString.":".$resource->getId();
		      
		      return $tag;		
		}
	}
?>