<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/view/adminpluginadssettingsview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );	

	class PluginAdsUpdateSettingsAction extends AdminAction
	{
		function PluginAdsUpdateSettingsAction( $request, $actionInfo )
		{
			$this->AdminAction( $request, $actionInfo );			
			
			$this->requireAdminPermission( "manage_ad_blocks" );			
		}
		
		function perform()
		{
			$pluginEnabled = (bool)$this->_request->getValue( "pluginEnabled" );
			$pluginAdsCode = $this->_request->getValue( "adCode" );
			$pluginAdsPosition = $this->_request->getValue( "adPosition", PLUGIN_ADS_POSITION_TOP );
			$pluginAdsBlogs = $this->_request->getValue( "adBlogs", PLUGIN_ADS_BLOGS_SHOW_ALL );					
			$pluginAdsBlogsList = $this->_request->getValue( "adBlogsList", Array());		
			
			// save the plugin settings
			$config =& Config::getConfig();
			$config->setValue( "plugin_ads_enabled", (bool)$pluginEnabled );
			$config->save();
			
			$this->_view = new AdminPluginAdsSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr( "ad_settings_updated_ok" ));
			$this->setCommonData();
		}
	}	
?>