<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/view/adminadblockslistview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/arrayvalidator.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblock.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblocks.class.php" );
	
	class AdminUpdateAdBlockAction extends AdminAction
	{
		function AdminUpdateAdBlockAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );			
			$this->requireAdminPermission( "manage_ad_blocks" );
			
			$this->registerFieldValidator( "adBlockName", new StringValidator());
			$this->registerFieldValidator( "adBlockMode", new IntegerValidator());
			$this->registerFieldValidator( "adBlockPosition", new IntegerValidator());			
			$this->registerFieldValidator( "adBlogsList", new ArrayValidator(), true );
			$this->registerFieldValidator( "adBlockId", new IntegerValidator());
			$this->registerField( "adBlockCode" );
			$view = new AdminPluginTemplatedView( $this->_blogInfo, "ads",  "editadblock" );
			$view->setErrorMessage( $this->_locale->tr("error_updating_adblock" ));
			$this->setValidationErrorView( $view );
		}
		
		function validationErrorProcessing()
		{			
			// let the parent class do its job
			$res = parent::validationErrorProcessing();
			
			// and now load the list of blogs that had already been placed in the list
			// and put it back in the view
			lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
			$blogs = new Blogs();
			$blogInfos = Array();
			
			$blogIds = $this->_request->getValue( "adBlogsList" );
			foreach( $blogIds as $blogId ) {
				$blogInfos[] = $blogs->getBlogInfo( $blogId );
			}
			
			$this->_view->setValue( "blogs", $blogInfos );
			
			return( $res );
		}
		
		function perform()
		{			
			// attempt to load the block			
			$blocks = new AdBlocks();
			$block = $blocks->getAdBlock( $this->_request->getValue( "adBlockId" ));
			if( !$block ) {
				$this->_view = new AdminAdBlocksListView( $this->_blogInfo );
				$this->_view->setErrorMessage( $this->_locale->tr("error_incorrect_adblock_id" ));
				$this->setCommonData();
				
				return( false );
			}
			
			$block->setName( $this->_request->getValue( "adBlockName" ));
			$mode = $this->_request->getValue( "adBlockMode" );
			$block->setMode( $mode );
			$block->setPosition( $this->_request->getValue( "adBlockPosition" ));
			$block->setCode( $this->_request->getValue( "adBlockCode" ));
			
			$mode = $this->_request->getValue( "adBlockMode" );
			if( $mode == PLUGIN_ADS_BLOGS_INCLUDE_LIST || $mode == PLUGIN_ADS_BLOGS_EXCLUDE_LIST ) {
				$block->setBlogs( $this->_request->getValue( "adBlogsList" ));
			}
			
			$blocks = new AdBlocks();
			if( !$blocks->updateAdBlock( $block )) {
				$this->_view = new AdminPluginTemplatedView( $this->_blogInfo, "ads",  "newadblock" );
				$this->_view->setErrorMessage( $this->_locale->tr("error_adding_adblock" ));
				$this->setCommonData( true );
				return( false );
			}
			
			$this->_view = new AdminAdBlocksListView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr( "adblock_updated_successfully" ));
			$this->setCommonData();
			
			return( true );
		}
	}
?>