<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/view/adminadblockslistview.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblocks.class.php" );	
	
	class AdminEditAdBlockAction extends AdminAction
	{
		function AdminEditAdBlockAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );	
			
			$this->registerFieldValidator( "blockId", new IntegerValidator());			
			$view = new AdminAdBlocksListView( $this->_blogInfo );
			$view->setErrorMessage( $this->_locale->tr("error_incorrect_adblock_id" ));
			$this->setValidationErrorView( $view );
					
			$this->requireAdminPermission( "manage_ad_blocks" );
		}
		
		function perform()
		{
			// attempt to load the block			
			$blocks = new AdBlocks();
			$block = $blocks->getAdBlock( $this->_request->getValue( "blockId" ));
			if( !$block ) {
				$this->_view = new AdminAdBlocksListView( $this->_blogInfo );
				$this->_view->setErrorMessage( $this->_locale->tr("error_incorrect_adblock_id" ));
				$this->setCommonData();
				
				return( false );
			}
			
			// proceed if ok
			$this->_view = new AdminPluginTemplatedView( $this->_blogInfo, "ads", "editadblock" );
			$this->_view->setValue( "adBlockId", $block->getId());
			$this->_view->setValue( "adBlockName", $block->getName());
			$this->_view->setValue( "adBlockMode", $block->getMode());
			$this->_view->setValue( "adBlockPosition", $block->getPosition());
			$this->_view->setValue( "blogs", $block->getBlogInfos());
			$this->_view->setValue( "adBlockCode", $block->getCode());
			
			$this->setCommonData();
			
			return( true );
		}
	}
?>