<?php
lt_include(PLOG_CLASS_PATH.'class/plugin/pluginbase.class.php');

class PluginAddCommentNotify extends PluginBase
{
    var $_pluginEnabled;
    var $_notifyTrackback;
    var $_useMSNClass;
    var $_msnClassFile;
    var $_msnUser;
    var $_msnPassword;
    var $_msnbot_spool;
    var $_tolist;

    function PluginAddCommentNotify($source = "")
    {
        $this->PluginBase($source);

        // Setup the plugin information
        $this->id = 'addcommentnotify';
        $this->author = 'twu2';
        $this->desc = 'send MSN via msnbot after add comment.';
        $this->version = '20070716';

        // Setup the locale
        $this->locales = array('en_UK', 'zh_TW');

        if ($source == 'admin')
            $this->initAdmin();
        $this->registerNotification(EVENT_POST_TRACKBACK_ADD);
        $this->registerNotification(EVENT_POST_COMMENT_ADD);
    }

    function initAdmin()
    {
        // Register the actions
        $this->registerAdminAction('addcommentnotify', 'PluginAddCommentNotifyConfigAction');
        $this->registerAdminAction('updateaddcommentnotify', 'PluginAddCommentNotifyUpdateConfigAction');

        // Set up the Admin menu options
        $this->addMenuEntry('/menu/controlCenter/manageSettings', 'AddCommentNotify', '?op=addcommentnotify');
    }

    function register()
    {
        $blogSettings = $this->blogInfo->getSettings();
        $this->_pluginEnabled = $blogSettings->getValue('plugin_addcommentnotify_enabled');
        $this->_notifyTrackback = $blogSettings->getValue('plugin_addcommentnotify_notifytrackback');
        $this->_useMSNClass = $blogSettings->getValue('addcommentnotify_usemsnclass');
        $this->_msnClassFile = $blogSettings->getValue('addcommentnotify_msnclass_file');
        $this->_msnUser = $blogSettings->getValue('addcommentnotify_msn_user');
        $this->_msnPassword = $blogSettings->getValue('addcommentnotify_msn_password');
        $this->_msnbot_spool = $blogSettings->getValue('addcommentnotify_msnbot_spool');
        $this->_tolist = $blogSettings->getValue('addcommentnotify_tolist');
        return true;
    }

    function isEnabled()
    {
        return $this->_pluginEnabled;
    }

    function process($eventType, $params)
    {
        $this->register();
        if (!$this->_pluginEnabled) return true;
        if (!$this->_useMSNClass)
            if (!is_dir($this->_msnbot_spool)) return true;
        $aTo = @explode(',', $this->_tolist);
        if (count($aTo) == 0) return true;
        $sTo = '';
        foreach ($aTo as $to) {
            @list($name, $domain, $network) = @explode('@', $to);
            if ($domain == null) continue;
            if ($network == null) $network = 1;
            if ($network != 1 && $network != 32) continue;
            $name = trim($name);
            $domain = trim($domain);
            if ($name === '' || $domain === '') continue;
            $user = $name.'@'.$domain.'@'.$network;
            if ($sTo === '')
                $sTo = $user;
            else
                $sTo .= ','.$user;
        }
        if ($sTo === '') return true;
        $url = $this->blogInfo->getBlogRequestGenerator();
        if ($eventType == EVENT_POST_TRACKBACK_ADD) {
	    if (!$this->_notifyTrackback) return true;
            if (!isset($params['trackback'])) return true;
            $trackback = $params['trackback'];
            $permalink = $url->postPermalink($trackback->getArticle());
            $sText = "Article: $permalink\n".
                     "Name: ".$trackback->getUserName()."\n".
                     "IP: ".$trackback->getClientIp()."\n".
                     "Trackback URL: ".$trackback->getUserUrl()."\n".
                     "Topic: ".$trackback->getNormalizedTopic()."\n".
                     "----------------------------------------\n".
                     $trackback->getNormalizedText();
        }
        else {
            if (!isset($params['comment'])) return true;
            $comment = $params['comment'];
            $permalink = $url->postPermalink($comment->getArticle()).'#'.$comment->getId();
/*
            $sText = "Date: ".$comment->getDate()."\n".
                     "Article: $permalink\n".
                     "IP: ".$comment->getClientIp()."\n".
                     "Name: ".$comment->getUserName()."\n".
                     "Email: ".$comment->getUserEmail()."\n".
                     "URL: ".$comment->getUserUrl()."\n".
                     "Topic: ".$comment->getNormalizedTopic()."\n".
                     "----------------------------------------\n".
                     $comment->getNormalizedText();
*/
            $sText = "Article: $permalink\n".
                     "Name: ".$comment->getUserName()."\n".
                     "Topic: ".$comment->getNormalizedTopic()."\n".
                     "----------------------------------------\n".
                     $comment->getNormalizedText();
        }
        if ($this->_useMSNClass) {
            require_once($this->_msnClassFile);
            $msn = new MSN;
            if ($msn->connect($this->_msnUser, $this->_msnPassword)) {
                $aTo = @explode(',', $sTo);
                $msn->sendMessage($sText, $aTo);
            }
            unset($msn);
        }
        else {
            $fname = $this->_msnbot_spool.'/addcomment_'.md5(strftime('%D $T').rand(1,100)).'_'.posix_getpid().'.msn';
            $fp = @fopen($fname, 'wt');
            if ($fp) {
                fputs($fp, "TO: $sTo\n$sText");
                fclose($fp);
                chmod($fname, 0666);
            }
        }
        return true;
    }
}
?>
