// xmillinspect.cpp : XMI file inspector infrastructure
//

#include "stdafx.h"

/* (de)contrustors */
XMIInspect::XMIInspect(int l)
{
	level = l;

	statesize = NULL;
 	numcontainers = NULL;
	pathindex = NULL;
	containersize = NULL;
	index = NULL;
	labels = NULL;
	exprs = NULL;
	exprinfo = NULL;
	numcontdata = NULL;
	numrealcontdata = NULL;
#if 0
	dictionarysizes = NULL;
#endif

	numlabels = 0;
	numexprs = 0;

	reset();

	buffer = NULL;
	realloc = true;
	newBuffer(BUFLEN);
}

XMIInspect::~XMIInspect()
{
	reset();
	trydela(buffer);
}

/* helpers */
void XMIInspect::newBuffer(long size)
{
	len = buflen = size;
	if (realloc) {
		trydela(buffer);
		buffer = new unsigned char[buflen+1];
		realloc = false;
	}
}

void XMIInspect::reset()
{
	state = XMIINS_READ_HEADER;

	gpc = NULL;

	trydela (index);
	trydela (statesize);
	trydela (numcontainers);
	trydela (containersize);
	trydela (pathindex);
	trydela (numcontdata);
	trydela (numrealcontdata);
#if 0
	trydela (dictionarysizes);
#endif

	if (labels) {
		for (int i=0; i<numlabels; i++) {
			delete[] labels[i];
		}
	}
	trydela (labels);

	if (exprs && exprinfo) {
		for (int i=0; i<numexprs; i++) {
			delete[] exprs[i];
			delete exprinfo[i];
		}
	}
	trydela (exprinfo);

	curptr = NULL;

	numopen = 0;
	numclose = 0;
	numdata = 0;
	numspecial = 0;
	numwhite = 0;

	numlabels = 0;
	numexprs = 0;
	numbuffers = 0;
	expectedcontainers = 0;
	foundcontainers = 0;
	compsize = 0;
	totalcompsize = 0;
	totaluncompsize = 0;
	totalrunsize = 0;
	runsize = 0;
	headersize = 0;
	totalheadersize = 0;
	numheaders = 0;
	totaldatasize = 0;
	globalsfound = 0;
	numlargeglobals = 0;
	globaldatasize = 0;

	len = buflen;
}

