/* XMLPPM: an XML compressor
Copyright (C) 2003 James Cheney

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contacting the author:
James Cheney
Computer Science Department
Cornell University
Ithaca, NY 14850

jcheney@cs.cornell.edu
*/

/* Derived 5/2001 from PPMd sources by James Cheney to interface to XMLPPM
 * Changes 3/2003 by Hedzer Westra to interface to XMill
 */

#include "stdafx.h"
#include "ZLib.hpp"

void PPMDIData::ariInitEncoder ()
{
  low = 0;
  range = DWORD (-1);
}

void PPMDIData::ariInitDecoder ()
{
    low=code=0;
    range=DWORD(-1);
    for (int i=0;i < 4;i++) {
      code=(code << 8) | fp->_getc();
    }
}

void PPMDIData::ariFlushEncoder ()
{
    for (int i=0;i < 4;i++) {
        fp->_putc(low >> 24);
        low <<= 8;
    }
}

void PPMDIData::ariEncodeSymbol ()
{
  low += SubRange.LowCount * (range /= SubRange.scale);
  range *= SubRange.HighCount - SubRange.LowCount;
}

void PPMDIData::ariShiftEncodeSymbol (UINT SHIFT)
{
  low += SubRange.LowCount * (range >>= SHIFT);
  range *= SubRange.HighCount - SubRange.LowCount;
}

int PPMDIData::ariGetCurrentCount ()
{
  return (code - low) / (range /= SubRange.scale);
}

UINT PPMDIData::ariGetCurrentShiftCount (UINT SHIFT)
{
  return (code - low) / (range >>= SHIFT);
}

void PPMDIData::ariRemoveSubrange ()
{
  low += range * SubRange.LowCount;
  range *= SubRange.HighCount - SubRange.LowCount;
}
