/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      10/11/2002  - edited by Hedzer Westra <hedzer@adlibsoft.com>
						  mostly copied from Options.cpp and adapted for in-mem API
      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

#pragma once

/* memory leak detection includes */
#ifdef WIN32
  #define CRTDBG_MAP_ALLOC
  #include <stdlib.h>
  #include <crtdbg.h>
#endif

#ifndef WIN32
  #define _snprintf snprintf
  #define strnicmp strncasecmp
#endif

/* disable some irritating warnings */
#pragma warning (disable: 4244)
#pragma warning (disable: 4267)
#pragma warning (disable: 4311)
#pragma warning (disable: 4312)

/* Include some default C libs */
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>

#ifdef WIN32
#include <fcntl.h>
#include <conio.h>
#else
#endif

typedef struct {
   int size;
   int order;
} level_settings ;

extern level_settings ppmsettings[XMILL_PPMDI_IDXS];

#ifdef _DEBUG
	/* externals */
	void checkDelete (void *c);
	void checkFree (void *c);
	void* checkedMalloc (unsigned int size);
	void setCheckAddress(void *c);

	/* macros */
	#define trydel(c) {if ((c)) {checkDelete((c)); delete (c); (c)=NULL;}}
	#define trydela(c) {if ((c)) {checkDelete((c)); delete[] (c); (c)=NULL;}}
	#define tryfree(c) {if ((c)) {checkFree((c)); free((c)); (c)=NULL;}}
	#define mymalloc(s) checkedMalloc(s)
#else
	#define trydel(c) {if ((c)) {delete (c); (c)=NULL;}}
	#define trydela(c) {if ((c)) {delete[] (c); (c)=NULL;}}
	#define tryfree(c) {if ((c)) {free((c)); (c)=NULL;}}
	#define mymalloc(s) malloc(s)
#endif

/* defines */
#define XMILL_BOTH	0
#define XMILL_COMP	1
#define XMILL_DECOMP	2

#define XMILL_MAXFILEBUFSIZE	30000

// The version is *added* to magic, so please check for overflows 
// into MAGIC_KEY_LOW MSB or MAGIC_KEY_HIGH when increasing..
#define XMILL_CURRENT_VERSION_MAJOR	0x01
#define XMILL_CURRENT_VERSION_MINOR	0x00
#define XMILL_CURRENT_VERSION			((XMILL_CURRENT_VERSION_MAJOR<<8) + XMILL_CURRENT_VERSION_MINOR)
#define XMILL_VERSION_1_0           0x0100
#define MAGIC_KEY_HIGH					0x05e3
#define MAGIC_KEY_LOW 					0xd29e
#define MAGIC_KEY_BASE					((MAGIC_KEY_HIGH<<16) + (MAGIC_KEY_LOW))
#define MAGIC_KEY							(MAGIC_KEY_BASE + XMILL_CURRENT_VERSION)
   // The uncompressed first block of an XMill file 
   // must start with these bytes
	// warning: stored as Sint32, please don't use more than 28
	// bits (so keep the highest nibble at 0).

#define XMILL_MEMORY_CUTOFF_MULT	1024L*1024L
#define XMILL_MEMORY_CUTOFF		8L*XMILL_MEMORY_CUTOFF_MULT

#define XMILL_PATHEXPR_OPT			"-p"

#ifndef STRLEN
	#define STRLEN 4096
#endif

/* includes */
#include "Output.hpp"
#include "XMLOutput.hpp"
#include "ContMan.hpp"
#include "CompressMan.hpp"
#include "VPathExprMan.hpp"
#include "Input.hpp"
#include "CurPath.hpp"
#include "LabelDict.hpp"
#include "MemMan.hpp"
#include "PathTree.hpp"
#include "UnCompCont.hpp"
#include "XMLParse.hpp"
#include "XMillAPI.h"
#include "XMillData.h"

#ifdef USE_FORWARD_DATAGUIDE
	#include "PathTree.hpp"
#endif

#ifdef NOTHREAD
class Session;
extern Session *session;
#endif
